/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.harness.internal.InProcessNeo4j;

public class Fixtures {
    private final List<String> fixtureStatements = new LinkedList<String>();
    private final List<Function<GraphDatabaseService, Void>> fixtureFunctions = new LinkedList<Function<GraphDatabaseService, Void>>();
    private final String cypherSuffix = "cyp";
    private final FileFilter cypherFileOrDirectoryFilter = file -> {
        if (file.isDirectory()) {
            return true;
        }
        String[] split = file.getName().split("\\.");
        String suffix = split[split.length - 1];
        return suffix.equals("cyp");
    };

    public void add(File fixturePath) {
        try {
            if (fixturePath.isDirectory()) {
                File[] fixtureFiles = fixturePath.listFiles(this.cypherFileOrDirectoryFilter);
                if (fixtureFiles != null) {
                    for (File file : fixtureFiles) {
                        this.add(file);
                    }
                }
                return;
            }
            this.add(Files.readString(fixturePath.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read fixture file '" + fixturePath.getAbsolutePath() + "': " + e.getMessage(), e);
        }
    }

    public void add(String statement) {
        if (!statement.trim().isEmpty()) {
            this.fixtureStatements.add(statement);
        }
    }

    public void add(Function<GraphDatabaseService, Void> fixtureFunction) {
        this.fixtureFunctions.add(fixtureFunction);
    }

    void applyTo(InProcessNeo4j controls) {
        GraphDatabaseService db = controls.defaultDatabaseService();
        for (String string : this.fixtureStatements) {
            Transaction tx = db.beginTx();
            try {
                tx.execute(string);
                tx.commit();
            }
            finally {
                if (tx == null) continue;
                tx.close();
            }
        }
        for (Function function : this.fixtureFunctions) {
            function.apply(db);
        }
    }
}

