/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.configuration.ssl.ClientAuth;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.harness.Neo4jBuilder;
import org.neo4j.harness.internal.Extensions;
import org.neo4j.harness.internal.Fixtures;
import org.neo4j.harness.internal.HarnessRegisteredProcs;
import org.neo4j.harness.internal.InProcessNeo4j;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.LogTimeZone;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.DisabledNeoServer;
import org.neo4j.server.NeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.server.database.GraphFactory;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

public abstract class AbstractInProcessNeo4jBuilder
implements Neo4jBuilder {
    private File serverFolder;
    private final Extensions unmanagedExtentions = new Extensions();
    private final HarnessRegisteredProcs procedures = new HarnessRegisteredProcs();
    private final Fixtures fixtures = new Fixtures();
    private final List<ExtensionFactory<?>> extensionFactories = new ArrayList();
    private boolean disabledServer;
    private final Config.Builder config = Config.newBuilder();

    public AbstractInProcessNeo4jBuilder() {
    }

    public AbstractInProcessNeo4jBuilder(File workingDir, String dataSubDir) {
        File dataDir = new File(workingDir, dataSubDir).getAbsoluteFile();
        this.withWorkingDir(dataDir);
    }

    @Override
    public Neo4jBuilder withWorkingDir(File workingDirectory) {
        File dataDir = new File(workingDirectory, this.randomFolderName()).getAbsoluteFile();
        this.setWorkingDirectory(dataDir);
        return this;
    }

    @Override
    public Neo4jBuilder copyFrom(File originalStoreDir) {
        try {
            FileUtils.copyDirectory((File)originalStoreDir, (File)this.serverFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public InProcessNeo4j build() {
        File userLogFile = new File(this.serverFolder, "neo4j.log");
        File internalLogFile = new File(this.serverFolder, "debug.log");
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            InProcessNeo4j inProcessNeo4j;
            block18: {
                OutputStream userLogOutputStream = AbstractInProcessNeo4jBuilder.openStream((FileSystemAbstraction)fileSystem, userLogFile);
                try {
                    Config dbConfig;
                    this.config.set(ServerSettings.third_party_packages, this.unmanagedExtentions.toList());
                    this.config.set(GraphDatabaseSettings.store_internal_log_path, (Object)internalLogFile.toPath().toAbsolutePath());
                    File certificates = new File(this.serverFolder, "certificates");
                    if (this.disabledServer) {
                        this.config.set(HttpConnector.enabled, (Object)false);
                        this.config.set(HttpsConnector.enabled, (Object)false);
                    }
                    if (((Boolean)(dbConfig = this.config.build()).get(HttpsConnector.enabled)).booleanValue() || ((Boolean)dbConfig.get(BoltConnector.enabled)).booleanValue() && dbConfig.get(BoltConnector.encryption_level) != BoltConnector.EncryptionLevel.DISABLED) {
                        SelfSignedCertificateFactory.create((File)certificates);
                        List<SslPolicyConfig> policies = List.of(SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.HTTPS), SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.BOLT));
                        for (SslPolicyConfig policy : policies) {
                            this.config.set(policy.enabled, (Object)Boolean.TRUE);
                            this.config.set(policy.base_directory, (Object)certificates.toPath());
                            this.config.set(policy.trust_all, (Object)true);
                            this.config.set(policy.client_auth, (Object)ClientAuth.NONE);
                        }
                        dbConfig = this.config.build();
                    }
                    FormattedLogProvider userLogProvider = FormattedLogProvider.withZoneId((ZoneId)((LogTimeZone)dbConfig.get(GraphDatabaseSettings.db_timezone)).getZoneId()).toOutputStream(userLogOutputStream);
                    GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies().userLogProvider((LogProvider)userLogProvider);
                    dependencies = dependencies.extensions(this.buildExtensionList(dependencies));
                    GraphFactory graphFactory = this.createGraphFactory(dbConfig);
                    boolean httpAndHttpsDisabled = (Boolean)dbConfig.get(HttpConnector.enabled) == false && (Boolean)dbConfig.get(HttpsConnector.enabled) == false;
                    NeoServer server = this.startNeo4jServer(dependencies, dbConfig, graphFactory, httpAndHttpsDisabled);
                    InProcessNeo4j controls = new InProcessNeo4j(this.serverFolder, userLogFile, internalLogFile, server, userLogOutputStream);
                    controls.start();
                    try {
                        this.fixtures.applyTo(controls);
                    }
                    catch (Exception e) {
                        controls.close();
                        throw e;
                    }
                    inProcessNeo4j = controls;
                    if (userLogOutputStream == null) break block18;
                }
                catch (Throwable throwable) {
                    if (userLogOutputStream != null) {
                        try {
                            userLogOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                userLogOutputStream.close();
            }
            return inProcessNeo4j;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract GraphFactory createGraphFactory(Config var1);

    protected abstract AbstractNeoServer createNeoServer(GraphFactory var1, Config var2, ExternalDependencies var3);

    @Override
    public <T> Neo4jBuilder withConfig(Setting<T> setting, T value) {
        this.config.set(setting, value);
        return this;
    }

    @Override
    public Neo4jBuilder withUnmanagedExtension(String mountPath, Class<?> extension) {
        return this.withUnmanagedExtension(mountPath, extension.getPackage().getName());
    }

    @Override
    public Neo4jBuilder withUnmanagedExtension(String mountPath, String packageName) {
        this.unmanagedExtentions.add(mountPath, packageName);
        return this;
    }

    @Override
    public Neo4jBuilder withExtensionFactories(Iterable<ExtensionFactory<?>> extensionFactories) {
        Iterables.addAll(this.extensionFactories, extensionFactories);
        return this;
    }

    @Override
    public Neo4jBuilder withDisabledServer() {
        this.disabledServer = true;
        return this;
    }

    @Override
    public Neo4jBuilder withFixture(File cypherFileOrDirectory) {
        this.fixtures.add(cypherFileOrDirectory);
        return this;
    }

    @Override
    public Neo4jBuilder withFixture(String fixtureStatement) {
        this.fixtures.add(fixtureStatement);
        return this;
    }

    @Override
    public Neo4jBuilder withFixture(Function<GraphDatabaseService, Void> fixtureFunction) {
        this.fixtures.add(fixtureFunction);
        return this;
    }

    @Override
    public Neo4jBuilder withProcedure(Class<?> procedureClass) {
        this.procedures.addProcedure(procedureClass);
        return this;
    }

    @Override
    public Neo4jBuilder withFunction(Class<?> functionClass) {
        this.procedures.addFunction(functionClass);
        return this;
    }

    @Override
    public Neo4jBuilder withAggregationFunction(Class<?> functionClass) {
        this.procedures.addAggregationFunction(functionClass);
        return this;
    }

    private NeoServer startNeo4jServer(GraphDatabaseDependencies dependencies, Config dbConfig, GraphFactory graphFactory, boolean httpAndHttpsDisabled) {
        return httpAndHttpsDisabled ? new DisabledNeoServer(graphFactory, (ExternalDependencies)dependencies, dbConfig) : this.createNeoServer(graphFactory, dbConfig, (ExternalDependencies)dependencies);
    }

    private Iterable<ExtensionFactory<?>> buildExtensionList(GraphDatabaseDependencies dependencies) {
        Iterable extensions = Iterables.append((Object)((Object)new Neo4jHarnessExtensions(this.procedures)), (Iterable)dependencies.extensions());
        return Iterables.addAll(this.extensionFactories, (Iterable)extensions);
    }

    private void setWorkingDirectory(File workingDir) {
        this.setDirectory(workingDir);
        this.withConfig(GraphDatabaseSettings.auth_enabled, (Object)false);
        this.withConfig(GraphDatabaseSettings.pagecache_memory, "8m");
        this.withConfig(HttpConnector.enabled, (Object)true);
        this.withConfig(HttpConnector.listen_address, new SocketAddress("localhost", 0));
        this.withConfig(HttpsConnector.enabled, (Object)false);
        this.withConfig(HttpsConnector.listen_address, new SocketAddress("localhost", 0));
        this.withConfig(BoltConnector.enabled, (Object)true);
        this.withConfig(BoltConnector.listen_address, new SocketAddress("localhost", 0));
    }

    private Neo4jBuilder setDirectory(File dir) {
        this.serverFolder = dir;
        this.config.set(GraphDatabaseSettings.neo4j_home, (Object)this.serverFolder.toPath().toAbsolutePath());
        return this;
    }

    private String randomFolderName() {
        return DigestUtils.md5Hex((String)Long.toString(ThreadLocalRandom.current().nextLong()));
    }

    private static StringBuilder describeJaxRsPackage(StringBuilder builder, ThirdPartyJaxRsPackage jaxRsPackage) {
        return builder.append(jaxRsPackage.getPackageName()).append("=").append(jaxRsPackage.getMountPoint());
    }

    private static OutputStream openStream(FileSystemAbstraction fs, File file) {
        try {
            return FileSystemUtils.createOrOpenAsOutputStream((FileSystemAbstraction)fs, (File)file, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create log file", e);
        }
    }

    private static class Neo4jHarnessExtensions
    extends ExtensionFactory<Dependencies> {
        private HarnessRegisteredProcs userProcs;

        Neo4jHarnessExtensions(HarnessRegisteredProcs userProcs) {
            super("harness");
            this.userProcs = userProcs;
        }

        public Lifecycle newInstance(ExtensionContext context, final Dependencies dependencies) {
            return new LifecycleAdapter(){

                public void start() throws Exception {
                    userProcs.applyTo(dependencies.procedures());
                }
            };
        }

        static interface Dependencies {
            public GlobalProcedures procedures();
        }
    }
}

