/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.junit.extension;

import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.harness.Neo4j;
import org.neo4j.harness.Neo4jBuilder;
import org.neo4j.harness.Neo4jBuilders;
import org.neo4j.harness.internal.InProcessNeo4j;
import org.neo4j.harness.junit.extension.Neo4jExtensionBuilder;

@PublicApi
public class Neo4jExtension
implements BeforeAllCallback,
AfterAllCallback,
ParameterResolver {
    private static final String NEO4J_NAMESPACE = "neo4j-extension";
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"neo4j-extension"});
    private Neo4jBuilder builder;

    public static Neo4jExtensionBuilder builder() {
        return new Neo4jExtensionBuilder();
    }

    public Neo4jExtension() {
        this(Neo4jBuilders.newInProcessBuilder());
    }

    protected Neo4jExtension(Neo4jBuilder builder) {
        this.builder = builder;
    }

    public void beforeAll(ExtensionContext context) {
        Neo4j neo = this.builder.build();
        DatabaseManagementService managementService = neo.databaseManagementService();
        GraphDatabaseService service = neo.defaultDatabaseService();
        context.getStore(NAMESPACE).put(Neo4j.class, (Object)neo);
        context.getStore(NAMESPACE).put(DatabaseManagementService.class, (Object)managementService);
        context.getStore(NAMESPACE).put(GraphDatabaseService.class, (Object)service);
    }

    public void afterAll(ExtensionContext context) {
        ExtensionContext.Store store = context.getStore(NAMESPACE);
        store.remove(GraphDatabaseService.class);
        store.remove(DatabaseManagementService.class);
        InProcessNeo4j controls = (InProcessNeo4j)store.remove(Neo4j.class, InProcessNeo4j.class);
        controls.close();
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        return paramType.equals(GraphDatabaseService.class) || paramType.equals(Neo4j.class) || paramType.equals(DatabaseManagementService.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Class<?> paramType = parameterContext.getParameter().getType();
        return extensionContext.getStore(NAMESPACE).get(paramType, paramType);
    }
}

