/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.junit.rule;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.function.Function;
import java.util.function.Supplier;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.harness.Neo4j;
import org.neo4j.harness.Neo4jBuilder;
import org.neo4j.harness.Neo4jBuilders;
import org.neo4j.kernel.extension.ExtensionFactory;

public class Neo4jRule
implements TestRule {
    private Neo4jBuilder builder;
    private Neo4j neo4j;
    private Supplier<PrintStream> dumpLogsOnFailureTarget;

    protected Neo4jRule(Neo4jBuilder builder) {
        this.builder = builder;
    }

    public Neo4jRule() {
        this(Neo4jBuilders.newInProcessBuilder());
    }

    public Neo4jRule(File workingDirectory) {
        this(Neo4jBuilders.newInProcessBuilder(workingDirectory));
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try (Neo4j sc = Neo4jRule.this.neo4j = Neo4jRule.this.builder.build();){
                    try {
                        base.evaluate();
                    }
                    catch (Throwable t) {
                        if (Neo4jRule.this.dumpLogsOnFailureTarget != null) {
                            sc.printLogs(Neo4jRule.this.dumpLogsOnFailureTarget.get());
                        }
                        throw t;
                    }
                }
            }
        };
    }

    public <T> Neo4jRule withConfig(Setting<T> key, T value) {
        this.builder = (Neo4jBuilder)this.builder.withConfig(key, value);
        return this;
    }

    public Neo4jRule withUnmanagedExtension(String mountPath, Class<?> extension) {
        this.builder = (Neo4jBuilder)this.builder.withUnmanagedExtension(mountPath, extension);
        return this;
    }

    public Neo4jRule withUnmanagedExtension(String mountPath, String packageName) {
        this.builder = (Neo4jBuilder)this.builder.withUnmanagedExtension(mountPath, packageName);
        return this;
    }

    public Neo4jRule withExtensionFactories(Iterable<ExtensionFactory<?>> extensionFactories) {
        this.builder = (Neo4jBuilder)this.builder.withExtensionFactories(extensionFactories);
        return this;
    }

    public Neo4jRule withDisabledServer() {
        this.builder = (Neo4jBuilder)this.builder.withDisabledServer();
        return this;
    }

    public Neo4jRule withFixture(File cypherFileOrDirectory) {
        this.builder = (Neo4jBuilder)this.builder.withFixture(cypherFileOrDirectory);
        return this;
    }

    public Neo4jRule withFixture(String fixtureStatement) {
        this.builder = (Neo4jBuilder)this.builder.withFixture(fixtureStatement);
        return this;
    }

    public Neo4jRule withFixture(Function<GraphDatabaseService, Void> fixtureFunction) {
        this.builder = (Neo4jBuilder)this.builder.withFixture(fixtureFunction);
        return this;
    }

    public Neo4jRule copyFrom(File sourceDirectory) {
        this.builder = (Neo4jBuilder)this.builder.copyFrom(sourceDirectory);
        return this;
    }

    public Neo4jRule withProcedure(Class<?> procedureClass) {
        this.builder = (Neo4jBuilder)this.builder.withProcedure(procedureClass);
        return this;
    }

    public Neo4jRule withFunction(Class<?> functionClass) {
        this.builder = (Neo4jBuilder)this.builder.withFunction(functionClass);
        return this;
    }

    public Neo4jRule withAggregationFunction(Class<?> functionClass) {
        this.builder = (Neo4jBuilder)this.builder.withAggregationFunction(functionClass);
        return this;
    }

    public Neo4jRule dumpLogsOnFailure(PrintStream out) {
        this.dumpLogsOnFailureTarget = () -> out;
        return this;
    }

    public Neo4jRule dumpLogsOnFailure(Supplier<PrintStream> out) {
        this.dumpLogsOnFailureTarget = out;
        return this;
    }

    public URI boltURI() {
        this.assertInitialised();
        return this.neo4j.boltURI();
    }

    public URI httpURI() {
        this.assertInitialised();
        return this.neo4j.httpURI();
    }

    public URI httpsURI() {
        this.assertInitialised();
        return this.neo4j.httpsURI();
    }

    public DatabaseManagementService databaseManagementService() {
        this.assertInitialised();
        return this.neo4j.databaseManagementService();
    }

    public GraphDatabaseService defaultDatabaseService() {
        this.assertInitialised();
        return this.neo4j.defaultDatabaseService();
    }

    public Configuration config() {
        this.assertInitialised();
        return this.neo4j.config();
    }

    private void assertInitialised() {
        if (this.neo4j == null) {
            throw new IllegalStateException("Cannot access Neo4j before or after the test runs.");
        }
    }
}

