/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.harness.ServerControls;
import org.neo4j.helpers.HostnamePort;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.server.NeoServer;

public class InProcessServerControls
implements ServerControls {
    private static final String DEFAULT_BOLT_CONNECTOR_KEY = "bolt";
    private final File serverFolder;
    private final File userLogFile;
    private final File internalLogFile;
    private final NeoServer server;
    private final Closeable additionalClosable;
    private ConnectorPortRegister connectorPortRegister;

    public InProcessServerControls(File serverFolder, File userLogFile, File internalLogFile, NeoServer server, Closeable additionalClosable) {
        this.serverFolder = serverFolder;
        this.userLogFile = userLogFile;
        this.internalLogFile = internalLogFile;
        this.server = server;
        this.additionalClosable = additionalClosable;
    }

    @Override
    public URI boltURI() {
        List connectors = this.server.getConfig().enabledBoltConnectors();
        BoltConnector defaultConnector = null;
        BoltConnector firstConnector = null;
        for (BoltConnector connector : connectors) {
            if (DEFAULT_BOLT_CONNECTOR_KEY.equals(connector.key())) {
                defaultConnector = connector;
            }
            if (firstConnector != null) continue;
            firstConnector = connector;
        }
        if (defaultConnector != null) {
            return this.connectorUri(DEFAULT_BOLT_CONNECTOR_KEY, (Connector)defaultConnector);
        }
        if (firstConnector != null) {
            return this.connectorUri(DEFAULT_BOLT_CONNECTOR_KEY, (Connector)firstConnector);
        }
        throw new IllegalStateException("Bolt connector is not configured");
    }

    @Override
    public URI httpURI() {
        return this.httpConnectorUri("http", HttpConnector.Encryption.NONE).orElseThrow(() -> new IllegalStateException("HTTP connector is not configured"));
    }

    @Override
    public Optional<URI> httpsURI() {
        return this.httpConnectorUri("https", HttpConnector.Encryption.TLS);
    }

    public void start() {
        this.server.start();
        this.connectorPortRegister = InProcessServerControls.connectorPortRegister(this.server);
    }

    @Override
    public void close() {
        this.server.stop();
        this.connectorPortRegister = null;
        try {
            this.additionalClosable.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this.looksLikeMd5Hash(this.serverFolder.getName())) {
                FileUtils.deleteRecursively((File)this.serverFolder);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clean up test server directory.", e);
        }
    }

    @Override
    public void printLogs(PrintStream out) {
        InProcessServerControls.printLog("User Log File", this.userLogFile, out);
        InProcessServerControls.printLog("Internal Log File", this.internalLogFile, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printLog(String description, File file, PrintStream out) {
        if (file != null && file.exists()) {
            out.println(String.format("---------- BEGIN %s ----------", description));
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                reader.lines().forEach(out::println);
            }
            catch (IOException ex) {
                try {
                    out.println("Unable to collect log files: " + ex.getMessage());
                    ex.printStackTrace(out);
                }
                catch (Throwable throwable) {
                    out.println(String.format("---------- END %s ----------", description));
                    throw throwable;
                }
                out.println(String.format("---------- END %s ----------", description));
            }
            out.println(String.format("---------- END %s ----------", description));
        }
    }

    private boolean looksLikeMd5Hash(String name) {
        return name.length() == 32;
    }

    @Override
    public GraphDatabaseService graph() {
        return this.server.getDatabase().getGraph();
    }

    @Override
    public Configuration config() {
        return this.server.getConfig();
    }

    private Optional<URI> httpConnectorUri(String scheme, HttpConnector.Encryption encryption) {
        return this.server.getConfig().enabledHttpConnectors().stream().filter(connector -> connector.encryptionLevel() == encryption).findFirst().map(connector -> this.connectorUri(scheme, (Connector)connector));
    }

    private URI connectorUri(String scheme, Connector connector) {
        HostnamePort hostPort = this.connectorPortRegister.getLocalAddress(connector.key());
        return URI.create(scheme + "://" + hostPort + "/");
    }

    private static ConnectorPortRegister connectorPortRegister(NeoServer server) {
        return (ConnectorPortRegister)server.getDatabase().getGraph().getDependencyResolver().resolveDependency(ConnectorPortRegister.class);
    }
}

