/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.junit;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.function.Function;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilder;
import org.neo4j.harness.TestServerBuilders;

public class Neo4jRule
implements TestRule,
TestServerBuilder {
    private TestServerBuilder builder;
    private ServerControls controls;
    private PrintStream dumpLogsOnFailureTarget;

    Neo4jRule(TestServerBuilder builder) {
        this.builder = builder;
    }

    public Neo4jRule() {
        this(TestServerBuilders.newInProcessBuilder());
    }

    public Neo4jRule(File workingDirectory) {
        this(TestServerBuilders.newInProcessBuilder(workingDirectory));
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try (ServerControls sc = Neo4jRule.this.controls = Neo4jRule.this.builder.newServer();){
                    try {
                        base.evaluate();
                    }
                    catch (Throwable t) {
                        if (Neo4jRule.this.dumpLogsOnFailureTarget != null) {
                            sc.printLogs(Neo4jRule.this.dumpLogsOnFailureTarget);
                        }
                        throw t;
                    }
                }
            }
        };
    }

    @Override
    public ServerControls newServer() {
        throw new UnsupportedOperationException("The server cannot be manually started via this class, it must be used as a JUnit rule.");
    }

    @Override
    public Neo4jRule withConfig(Setting<?> key, String value) {
        this.builder = this.builder.withConfig(key, value);
        return this;
    }

    @Override
    public Neo4jRule withConfig(String key, String value) {
        this.builder = this.builder.withConfig(key, value);
        return this;
    }

    @Override
    public Neo4jRule withExtension(String mountPath, Class<?> extension) {
        this.builder = this.builder.withExtension(mountPath, extension);
        return this;
    }

    @Override
    public Neo4jRule withExtension(String mountPath, String packageName) {
        this.builder = this.builder.withExtension(mountPath, packageName);
        return this;
    }

    @Override
    public Neo4jRule withFixture(File cypherFileOrDirectory) {
        this.builder = this.builder.withFixture(cypherFileOrDirectory);
        return this;
    }

    @Override
    public Neo4jRule withFixture(String fixtureStatement) {
        this.builder = this.builder.withFixture(fixtureStatement);
        return this;
    }

    @Override
    public Neo4jRule withFixture(Function<GraphDatabaseService, Void> fixtureFunction) {
        this.builder = this.builder.withFixture(fixtureFunction);
        return this;
    }

    @Override
    public Neo4jRule copyFrom(File sourceDirectory) {
        this.builder = this.builder.copyFrom(sourceDirectory);
        return this;
    }

    @Override
    public Neo4jRule withProcedure(Class<?> procedureClass) {
        this.builder = this.builder.withProcedure(procedureClass);
        return this;
    }

    @Override
    public Neo4jRule withFunction(Class<?> functionClass) {
        this.builder = this.builder.withFunction(functionClass);
        return this;
    }

    @Override
    public Neo4jRule withAggregationFunction(Class<?> functionClass) {
        this.builder = this.builder.withAggregationFunction(functionClass);
        return this;
    }

    public Neo4jRule dumpLogsOnFailure(PrintStream out) {
        this.dumpLogsOnFailureTarget = out;
        return this;
    }

    public URI boltURI() {
        if (this.controls == null) {
            throw new IllegalStateException("Cannot access instance URI before or after the test runs.");
        }
        return this.controls.boltURI();
    }

    public URI httpURI() {
        if (this.controls == null) {
            throw new IllegalStateException("Cannot access instance URI before or after the test runs.");
        }
        return this.controls.httpURI();
    }

    public URI httpsURI() {
        if (this.controls == null) {
            throw new IllegalStateException("Cannot access instance URI before or after the test runs.");
        }
        return this.controls.httpsURI().orElseThrow(() -> new IllegalStateException("HTTPS connector is not configured"));
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.controls.graph();
    }

    public Configuration getConfig() {
        return this.controls.config();
    }
}

