/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.harness.ServerControls;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.server.AbstractNeoServer;

public class InProcessServerControls
implements ServerControls {
    private final File serverFolder;
    private final AbstractNeoServer server;
    private final Closeable additionalClosable;

    public InProcessServerControls(File serverFolder, AbstractNeoServer server, Closeable additionalClosable) {
        this.serverFolder = serverFolder;
        this.server = server;
        this.additionalClosable = additionalClosable;
    }

    @Override
    public URI boltURI() {
        AdvertisedSocketAddress address = (AdvertisedSocketAddress)this.server.getConfig().get(new BoltConnector((String)"bolt").advertised_address);
        return URI.create("bolt://" + address.getHostname() + ":" + address.getPort());
    }

    @Override
    public URI httpURI() {
        return this.server.baseUri();
    }

    @Override
    public Optional<URI> httpsURI() {
        return this.server.httpsUri();
    }

    public void start() {
        this.server.start();
    }

    @Override
    public void close() {
        this.server.stop();
        try {
            this.additionalClosable.close();
        }
        catch (Throwable e) {
            throw Exceptions.launderedException((Throwable)e);
        }
        try {
            if (this.looksLikeMd5Hash(this.serverFolder.getName())) {
                FileUtils.deleteRecursively((File)this.serverFolder);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clean up test server directory.", e);
        }
    }

    private boolean looksLikeMd5Hash(String name) {
        return name.length() == 32;
    }

    @Override
    public GraphDatabaseService graph() {
        return this.server.getDatabase().getGraph();
    }

    @Override
    public Configuration config() {
        return this.server.getConfig();
    }
}

