/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.apache.commons.io.FileUtils;
import org.neo4j.dbms.DatabaseManagementSystemSettings;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilder;
import org.neo4j.harness.internal.Extensions;
import org.neo4j.harness.internal.Fixtures;
import org.neo4j.harness.internal.HarnessRegisteredProcs;
import org.neo4j.harness.internal.InProcessServerControls;
import org.neo4j.harness.internal.Ports;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.file.Files;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.FormattedLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.configuration.ThirdPartyJaxRsPackage;
import org.neo4j.test.Digests;

public abstract class AbstractInProcessServerBuilder
implements TestServerBuilder {
    private final FileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
    private File serverFolder;
    private final Extensions extensions = new Extensions();
    private final HarnessRegisteredProcs procedures = new HarnessRegisteredProcs();
    private final Fixtures fixtures = new Fixtures();
    private final Map<String, String> config = new HashMap<String, String>();

    public AbstractInProcessServerBuilder(File workingDir) {
        File dataDir = new File(workingDir, this.randomFolderName()).getAbsoluteFile();
        this.init(dataDir);
    }

    private void init(File workingDir) {
        this.setDirectory(workingDir);
        this.withConfig(GraphDatabaseSettings.auth_enabled, "false");
        this.withConfig(GraphDatabaseSettings.pagecache_memory, "8m");
        this.withConfig(ServerSettings.httpConnector((String)"1").type, "HTTP");
        this.withConfig(ServerSettings.httpConnector((String)"1").enabled, "true");
        this.withConfig(ServerSettings.httpConnector((String)"1").address, "localhost:" + Integer.toString(this.freePort(1001, 5000)));
        this.withConfig(GraphDatabaseSettings.boltConnector((String)"0").type, "BOLT");
        this.withConfig(GraphDatabaseSettings.boltConnector((String)"0").enabled, "true");
        this.withConfig(GraphDatabaseSettings.boltConnector((String)"0").address, "localhost:" + Integer.toString(this.freePort(5001, 9000)));
    }

    @Override
    public TestServerBuilder copyFrom(File originalStoreDir) {
        try {
            FileUtils.copyDirectory((File)originalStoreDir, (File)this.serverFolder);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public ServerControls newServer() {
        OutputStream logOutputStream;
        try {
            logOutputStream = Files.createOrOpenAsOuputStream((FileSystemAbstraction)this.fileSystem, (File)new File(this.serverFolder, "neo4j.log"), (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create log file", e);
        }
        this.config.put(ServerSettings.third_party_packages.name(), AbstractInProcessServerBuilder.toStringForThirdPartyPackageProperty(this.extensions.toList()));
        FormattedLogProvider userLogProvider = FormattedLogProvider.toOutputStream((OutputStream)logOutputStream);
        GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies();
        dependencies = dependencies.kernelExtensions(Iterables.append((Object)((Object)new Neo4jHarnessExtensions(this.procedures)), (Iterable)dependencies.kernelExtensions())).userLogProvider((LogProvider)userLogProvider);
        AbstractNeoServer neoServer = this.createNeoServer(this.config, (GraphDatabaseFacadeFactory.Dependencies)dependencies, userLogProvider);
        InProcessServerControls controls = new InProcessServerControls(this.serverFolder, neoServer, logOutputStream);
        controls.start();
        try {
            this.fixtures.applyTo(controls);
        }
        catch (Exception e) {
            controls.close();
            throw Exceptions.launderedException((Throwable)e);
        }
        return controls;
    }

    protected abstract AbstractNeoServer createNeoServer(Map<String, String> var1, GraphDatabaseFacadeFactory.Dependencies var2, FormattedLogProvider var3);

    @Override
    public TestServerBuilder withConfig(Setting<?> key, String value) {
        return this.withConfig(key.name(), value);
    }

    @Override
    public TestServerBuilder withConfig(String key, String value) {
        this.config.put(key, value);
        return this;
    }

    @Override
    public TestServerBuilder withExtension(String mountPath, Class<?> extension) {
        return this.withExtension(mountPath, extension.getPackage().getName());
    }

    @Override
    public TestServerBuilder withExtension(String mountPath, String packageName) {
        this.extensions.add(mountPath, packageName);
        return this;
    }

    @Override
    public TestServerBuilder withFixture(File cypherFileOrDirectory) {
        this.fixtures.add(cypherFileOrDirectory);
        return this;
    }

    @Override
    public TestServerBuilder withFixture(String fixtureStatement) {
        this.fixtures.add(fixtureStatement);
        return this;
    }

    @Override
    public TestServerBuilder withFixture(Function<GraphDatabaseService, Void> fixtureFunction) {
        this.fixtures.add(fixtureFunction);
        return this;
    }

    @Override
    public TestServerBuilder withProcedure(Class<?> procedureClass) {
        this.procedures.add(procedureClass);
        return this;
    }

    private TestServerBuilder setDirectory(File dir) {
        this.serverFolder = dir;
        this.config.put(DatabaseManagementSystemSettings.data_directory.name(), this.serverFolder.getAbsolutePath());
        return this;
    }

    private String randomFolderName() {
        return Digests.md5Hex((String)Long.toString(ThreadLocalRandom.current().nextLong()));
    }

    private int freePort(int startRange, int endRange) {
        try {
            return Ports.findFreePort("localhost", new int[]{startRange, endRange}).getPort();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find an available port: " + e.getMessage(), e);
        }
    }

    private static String toStringForThirdPartyPackageProperty(List<ThirdPartyJaxRsPackage> extensions) {
        ThirdPartyJaxRsPackage jaxRsPackage;
        String propertyString = "";
        int packageCount = extensions.size();
        if (packageCount == 0) {
            return propertyString;
        }
        for (int i = 0; i < packageCount - 1; ++i) {
            jaxRsPackage = extensions.get(i);
            propertyString = propertyString + jaxRsPackage.getPackageName() + "=" + jaxRsPackage.getMountPoint() + ",";
        }
        jaxRsPackage = extensions.get(packageCount - 1);
        propertyString = propertyString + jaxRsPackage.getPackageName() + "=" + jaxRsPackage.getMountPoint();
        return propertyString;
    }

    private static class Neo4jHarnessExtensions
    extends KernelExtensionFactory<Dependencies> {
        private HarnessRegisteredProcs userProcs;

        public Neo4jHarnessExtensions(HarnessRegisteredProcs userProcs) {
            super("harness");
            this.userProcs = userProcs;
        }

        public Lifecycle newInstance(KernelContext context, final Dependencies dependencies) throws Throwable {
            return new LifecycleAdapter(){

                public void start() throws Throwable {
                    userProcs.applyTo(dependencies.procedures());
                }
            };
        }

        static interface Dependencies {
            public Procedures procedures();
        }
    }
}

