/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonNode;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.server.rest.domain.JsonHelper;
import org.neo4j.server.rest.domain.JsonParseException;

public class Fixtures {
    private static final String TX_COMMIT_ENDPOINT = "/db/data/transaction/commit";
    private final List<String> fixtureStatements = new LinkedList<String>();
    private final String cypherSuffix = "cyp";
    private final FileFilter cypherFileOrDirectoryFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String[] split = file.getName().split("\\.");
            String suffix = split[split.length - 1];
            return suffix.equals("cyp");
        }
    };

    public void add(File fixturePath) {
        try {
            if (fixturePath.isDirectory()) {
                for (File file : fixturePath.listFiles(this.cypherFileOrDirectoryFilter)) {
                    this.add(file);
                }
                return;
            }
            this.add(FileUtils.readTextFile((File)fixturePath, (Charset)Charset.forName("UTF-8")));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read fixture file '" + fixturePath.getAbsolutePath() + "': " + e.getMessage(), e);
        }
    }

    public void add(String statement) {
        if (statement.trim().length() > 0) {
            this.fixtureStatements.add(statement);
        }
    }

    public void applyTo(URI serverBaseURI) {
        if (this.fixtureStatements.size() > 0) {
            Client client = new Client();
            ClientRequest req = ((ClientRequest.Builder)((ClientRequest.Builder)ClientRequest.create().accept(new String[]{"application/json"})).entity((Object)JsonHelper.createJsonFrom((Object)MapUtil.map((Object[])new Object[]{"statements", this.statementPayload()})), MediaType.APPLICATION_JSON_TYPE)).build(serverBaseURI.resolve(TX_COMMIT_ENDPOINT), "POST");
            ClientResponse response = client.handle(req);
            this.ensureInstallSuccessful(response);
        }
    }

    private void ensureInstallSuccessful(ClientResponse response) {
        String entity = (String)response.getEntity(String.class);
        try {
            JsonNode errors = JsonHelper.jsonNode((String)entity).get("errors");
            if (errors.size() > 0) {
                throw new RuntimeException("Failed to install fixtures: " + errors.get(0).get("message").asText());
            }
        }
        catch (JsonParseException e) {
            throw new RuntimeException("Fatal, server returned an invalid response, '" + e.getMessage() + "': " + entity);
        }
    }

    private List<Map<String, Object>> statementPayload() {
        LinkedList<Map<String, Object>> statements = new LinkedList<Map<String, Object>>();
        for (String fixtureStatement : this.fixtureStatements) {
            statements.add(MapUtil.map((Object[])new Object[]{"statement", fixtureStatement}));
        }
        return statements;
    }
}

