/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.neo4j.harness.ServerControls;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.server.AbstractNeoServer;

public class InProcessServerControls
implements ServerControls {
    private final File serverFolder;
    private final AbstractNeoServer server;
    private final Lifecycle additionalLifeToManage;

    public InProcessServerControls(File serverFolder, AbstractNeoServer server, Lifecycle additionalLifeToManage) {
        this.serverFolder = serverFolder;
        this.server = server;
        this.additionalLifeToManage = additionalLifeToManage;
    }

    @Override
    public URI httpURI() {
        return this.server.baseUri();
    }

    @Override
    public URI httpsURI() {
        return this.server.httpsUri();
    }

    public void start() {
        this.server.start();
    }

    @Override
    public void close() {
        this.server.stop();
        try {
            this.additionalLifeToManage.shutdown();
        }
        catch (Throwable e) {
            throw Exceptions.launderedException((Throwable)e);
        }
        try {
            if (this.looksLikeMd5Hash(this.serverFolder.getName())) {
                FileUtils.deleteRecursively((File)this.serverFolder);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to clean up test server directory.", e);
        }
    }

    private boolean looksLikeMd5Hash(String name) {
        return name.length() == 32;
    }
}

