/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilder;
import org.neo4j.harness.internal.Extensions;
import org.neo4j.harness.internal.Fixtures;
import org.neo4j.harness.internal.InProcessServerControls;
import org.neo4j.harness.internal.MapConfigurator;
import org.neo4j.harness.internal.Ports;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseDependencies;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.ClassicLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.ConfigurationBuilder;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.test.Digests;

public class InProcessServerBuilder
implements TestServerBuilder {
    private File serverFolder;
    private Logging logging;
    private final Extensions extensions = new Extensions();
    private final Fixtures fixtures = new Fixtures();
    private final Map<String, String> config = new HashMap<String, String>();

    public InProcessServerBuilder(File workingDir) {
        this.setDirectory(workingDir);
        this.withConfig(ServerSettings.auth_enabled, "false");
        this.withConfig(Configurator.WEBSERVER_PORT_PROPERTY_KEY, Integer.toString(this.freePort()));
    }

    @Override
    public ServerControls newServer() {
        GraphDatabaseDependencies dependencies = GraphDatabaseDependencies.newDependencies().logging(this.logging);
        InProcessServerControls controls = new InProcessServerControls(this.serverFolder, (AbstractNeoServer)new CommunityNeoServer((ConfigurationBuilder)new MapConfigurator(this.config, this.extensions.toList()), (InternalAbstractGraphDatabase.Dependencies)dependencies), (Lifecycle)this.logging);
        controls.start();
        try {
            this.fixtures.applyTo(controls.httpURI());
        }
        catch (RuntimeException e) {
            controls.close();
            throw e;
        }
        return controls;
    }

    @Override
    public TestServerBuilder withConfig(Setting<?> key, String value) {
        return this.withConfig(key.name(), value);
    }

    @Override
    public TestServerBuilder withConfig(String key, String value) {
        this.config.put(key, value);
        return this;
    }

    @Override
    public TestServerBuilder withExtension(String mountPath, Class<?> extension) {
        return this.withExtension(mountPath, extension.getPackage().getName());
    }

    @Override
    public TestServerBuilder withExtension(String mountPath, String packageName) {
        this.extensions.add(mountPath, packageName);
        return this;
    }

    @Override
    public TestServerBuilder withFixture(File cypherFileOrDirectory) {
        this.fixtures.add(cypherFileOrDirectory);
        return this;
    }

    @Override
    public TestServerBuilder withFixture(String fixtureStatement) {
        this.fixtures.add(fixtureStatement);
        return this;
    }

    private TestServerBuilder setDirectory(File dir) {
        this.serverFolder = new File(dir, this.randomFolderName()).getAbsoluteFile();
        this.config.put(Configurator.DATABASE_LOCATION_PROPERTY_KEY, this.serverFolder.getAbsolutePath());
        this.logging = new ClassicLoggingService(new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_dir.name(), this.serverFolder.getAbsolutePath()})));
        return this;
    }

    private String randomFolderName() {
        return Digests.md5Hex((String)Long.toString(new Random().nextLong()));
    }

    private int freePort() {
        try {
            return Ports.findFreePort("localhost", new int[]{7474, 10000}).getPort();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find an available port: " + e.getMessage(), e);
        }
    }
}

