/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.harness.internal;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.harness.ServerControls;
import org.neo4j.harness.TestServerBuilder;
import org.neo4j.harness.internal.Extensions;
import org.neo4j.harness.internal.Fixtures;
import org.neo4j.harness.internal.InProcessServerControls;
import org.neo4j.harness.internal.MapConfigurator;
import org.neo4j.harness.internal.Ports;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.logging.ClassicLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.server.AbstractNeoServer;
import org.neo4j.server.CommunityNeoServer;
import org.neo4j.server.configuration.Configurator;
import org.neo4j.test.Digests;

public class InProcessServerBuilder
implements TestServerBuilder {
    private File serverFolder;
    private Logging logging;
    private Extensions extensions = new Extensions();
    private Fixtures fixtures = new Fixtures();
    private final Map<String, Object> config = new HashMap<String, Object>();

    public InProcessServerBuilder(File workingDir) {
        this.setDirectory(workingDir);
        this.withConfig("org.neo4j.server.webserver.port", Integer.toString(this.freePort()));
    }

    @Override
    public ServerControls newServer() {
        InProcessServerControls controls = new InProcessServerControls(this.serverFolder, (AbstractNeoServer)new CommunityNeoServer((Configurator)new MapConfigurator(this.config, this.extensions.toList()), this.logging), (Lifecycle)this.logging);
        controls.start();
        try {
            this.fixtures.applyTo(controls.httpURI());
        }
        catch (RuntimeException e) {
            controls.close();
            throw e;
        }
        return controls;
    }

    @Override
    public TestServerBuilder withConfig(Setting<?> key, String value) {
        return this.withConfig(key.name(), value);
    }

    @Override
    public TestServerBuilder withConfig(String key, String value) {
        this.config.put(key, value);
        return this;
    }

    @Override
    public TestServerBuilder withExtension(String mountPath, Class<?> extension) {
        return this.withExtension(mountPath, extension.getPackage().getName());
    }

    @Override
    public TestServerBuilder withExtension(String mountPath, String packageName) {
        this.extensions.add(mountPath, packageName);
        return this;
    }

    @Override
    public TestServerBuilder withFixture(File cypherFileOrDirectory) {
        this.fixtures.add(cypherFileOrDirectory);
        return this;
    }

    @Override
    public TestServerBuilder withFixture(String fixtureStatement) {
        this.fixtures.add(fixtureStatement);
        return this;
    }

    private TestServerBuilder setDirectory(File dir) {
        this.serverFolder = new File(dir, this.randomFolderName()).getAbsoluteFile();
        this.config.put("org.neo4j.server.database.location", this.serverFolder.getAbsolutePath());
        this.logging = new ClassicLoggingService(new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_dir.name(), this.serverFolder.getAbsolutePath()})));
        return this;
    }

    private String randomFolderName() {
        return Digests.md5Hex((String)Long.toString(new Random().nextLong()));
    }

    private int freePort() {
        try {
            return Ports.findFreePort("localhost", new int[]{7474, 10000}).getPort();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to find an available port: " + e.getMessage(), e);
        }
    }
}

