/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.timeout;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.core.ConditionTimeoutException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.LifecycleMethodExecutionExceptionHandler;
import org.junit.jupiter.api.extension.TestWatcher;
import org.neo4j.internal.utils.DumpUtils;

public class VerboseTimeoutExceptionExtension
implements TestWatcher,
LifecycleMethodExecutionExceptionHandler {
    public void testFailed(ExtensionContext context, Throwable cause) {
        this.handleFailure(context.getDisplayName(), context.getRequiredTestMethod().getName(), cause);
    }

    private void handleFailure(String displayName, String testMethod, Throwable cause) {
        if (VerboseTimeoutExceptionExtension.isTimeout(cause)) {
            cause.addSuppressed(new ThreadDump(String.format("Test %s-%s timed out. ", displayName, testMethod)));
        }
    }

    public void handleBeforeAllMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.handleFailure(context.getDisplayName(), "BeforeAll", throwable);
        throw throwable;
    }

    public void handleBeforeEachMethodExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        this.handleFailure(context.getDisplayName(), "BeforeEach", throwable);
        throw throwable;
    }

    private static boolean isTimeout(Throwable throwable) {
        return throwable != null && (throwable instanceof TimeoutException || throwable instanceof ConditionTimeoutException || StringUtils.contains((CharSequence)throwable.getMessage(), (CharSequence)"timed out") || !Objects.equals(throwable, throwable.getCause()) && VerboseTimeoutExceptionExtension.isTimeout(throwable.getCause()) || Arrays.stream(throwable.getSuppressed()).anyMatch(VerboseTimeoutExceptionExtension::isTimeout));
    }

    static class ThreadDump
    extends RuntimeException {
        ThreadDump(String header) {
            super(header + DumpUtils.threadDump());
            this.setStackTrace(new StackTraceElement[0]);
        }
    }
}

