/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.time.Duration;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.testkit.engine.EngineTestKit;
import org.junit.platform.testkit.engine.EventConditions;
import org.junit.platform.testkit.engine.Events;
import org.neo4j.internal.helpers.ProcessUtils;

public class ForkingTestExtension
implements BeforeEachCallback,
InvocationInterceptor {
    private static final int SUCCESS_CODE = 66;
    private static boolean inFork;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ByteArrayOutputStream err = new ByteArrayOutputStream();

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        if (inFork) {
            return;
        }
        String testClass = extensionContext.getRequiredTestClass().getName();
        String methodName = extensionContext.getRequiredTestMethod().getName();
        int exitCode = ProcessUtils.executeJava((ByteArrayOutputStream)this.out, (ByteArrayOutputStream)this.err, (Duration)Duration.ofMinutes(20L), (String[])new String[]{ForkingTestExtension.class.getName(), testClass, methodName});
        ((AbstractIntegerAssert)Assertions.assertThat((int)exitCode).as("Out: %s %nErr: %s", new Object[]{this.out.toString(), this.err.toString()})).isEqualTo(66);
    }

    public static void main(String[] args) {
        inFork = true;
        String className = args[0];
        String methodName = args[1];
        Events testEvents = EngineTestKit.engine((String)"junit-jupiter").selectors(new DiscoverySelector[]{DiscoverySelectors.selectMethod((String)className, (String)methodName)}).enableImplicitConfigurationParameters(true).execute().testEvents();
        testEvents.assertThatEvents().haveExactly(1, EventConditions.event((Condition[])new Condition[]{EventConditions.finishedSuccessfully()}));
        System.exit(66);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        ForkingTestExtension.onlyRunInFork(invocation);
    }

    public void interceptBeforeAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        ForkingTestExtension.onlyRunInFork(invocation);
    }

    public void interceptBeforeEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        ForkingTestExtension.onlyRunInFork(invocation);
    }

    public void interceptAfterEachMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        ForkingTestExtension.onlyRunInFork(invocation);
    }

    public void interceptAfterAllMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        ForkingTestExtension.onlyRunInFork(invocation);
    }

    private static void onlyRunInFork(InvocationInterceptor.Invocation<Void> invocation) throws Throwable {
        if (inFork) {
            invocation.proceed();
        } else {
            invocation.skip();
        }
    }
}

