/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.mockito.mock;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;

public class SpatialMocks {
    public static MockPoint mockPoint(double x, double y, CRS crs) {
        return new MockPoint(x, y, crs);
    }

    public static MockPoint3D mockPoint(double x, double y, double z, CRS crs) {
        return new MockPoint3D(x, y, z, crs);
    }

    public static MockGeometry mockGeometry(String geometryType, List<Coordinate> coordinates, CRS crs) {
        return new MockGeometry(geometryType, coordinates, crs);
    }

    public static CRS mockWGS84() {
        return SpatialMocks.mockCRS(4326, "WGS-84", "https://spatialreference.org/ref/epsg/4326/");
    }

    public static CRS mockCartesian() {
        return SpatialMocks.mockCRS(7203, "cartesian", "https://spatialreference.org/ref/sr-org/7203/");
    }

    public static CRS mockWGS84_3D() {
        return SpatialMocks.mockCRS(4979, "WGS-84-3D", "https://spatialreference.org/ref/epsg/4979/");
    }

    public static CRS mockCartesian_3D() {
        return SpatialMocks.mockCRS(9157, "cartesian-3D", "https://spatialreference.org/ref/sr-org/9157/");
    }

    private static CRS mockCRS(final int code, final String type, final String href) {
        return new CRS(){

            public int getCode() {
                return code;
            }

            public String getType() {
                return type;
            }

            public String getHref() {
                return href;
            }
        };
    }

    private static class MockPoint
    extends MockGeometry
    implements Point {
        private final Coordinate coordinate;

        private MockPoint(double x, double y, CRS crs) {
            super("Point", new ArrayList<Coordinate>(), crs);
            this.coordinate = new Coordinate(new double[]{x, y});
            this.coordinates.add(this.coordinate);
        }
    }

    private static class MockPoint3D
    extends MockGeometry
    implements Point {
        private final Coordinate coordinate;

        private MockPoint3D(double x, double y, double z, CRS crs) {
            super("Point", new ArrayList<Coordinate>(), crs);
            this.coordinate = new Coordinate(new double[]{x, y, z});
            this.coordinates.add(this.coordinate);
        }
    }

    private static class MockGeometry
    implements Geometry {
        final String geometryType;
        final List<Coordinate> coordinates;
        protected final CRS crs;

        private MockGeometry(String geometryType, List<Coordinate> coordinates, CRS crs) {
            this.geometryType = geometryType;
            this.coordinates = coordinates;
            this.crs = crs;
        }

        public String getGeometryType() {
            return this.geometryType;
        }

        public List<Coordinate> getCoordinates() {
            return this.coordinates;
        }

        public CRS getCRS() {
            return this.crs;
        }

        public String toString() {
            return this.geometryType;
        }
    }
}

