/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.actors;

import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.neo4j.test.extension.actors.Actor;

class ActorImpl
implements Actor {
    private static final FutureTask<Void> STOP_SIGNAL = new FutureTask<Void>(() -> null);
    private final LinkedTransferQueue<FutureTask<?>> queue;
    private final Thread thread;
    private final AtomicBoolean started = new AtomicBoolean();
    private volatile boolean stopped;
    private volatile boolean executing;

    ActorImpl(ThreadGroup threadGroup, String name) {
        this.queue = new LinkedTransferQueue();
        this.thread = new Thread(threadGroup, this::runActor, name);
    }

    private <T> void enqueue(FutureTask<T> task) {
        if (this.stopped) {
            throw new IllegalStateException("Test actor is stopped: " + String.valueOf(this.thread));
        }
        this.queue.offer(task);
        if (!this.started.get() && this.started.compareAndSet(false, true)) {
            this.thread.start();
        }
    }

    private void runActor() {
        try {
            FutureTask<?> task;
            while (!this.stopped && (task = this.queue.take()) != STOP_SIGNAL) {
                try {
                    this.executing = true;
                    task.run();
                }
                finally {
                    this.executing = false;
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        this.stopped = true;
        this.queue.offer(STOP_SIGNAL);
    }

    public void join() throws InterruptedException {
        Thread.interrupted();
        this.thread.join();
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        FutureTask<T> task = new FutureTask<T>(callable);
        this.enqueue(task);
        return task;
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T result) {
        FutureTask<T> task = new FutureTask<T>(runnable, result);
        this.enqueue(task);
        return task;
    }

    @Override
    public Future<Void> submit(Runnable runnable) {
        return this.submit(runnable, null);
    }

    @Override
    public void untilWaiting() throws InterruptedException {
        while (true) {
            Thread.State state = this.thread.getState();
            boolean executing = this.executing;
            if (executing && (state == Thread.State.WAITING || state == Thread.State.TIMED_WAITING)) {
                return;
            }
            if (state == Thread.State.TERMINATED) {
                throw new AssertionError((Object)("Actor thread " + this.thread.getName() + " has terminated."));
            }
            if (state == Thread.State.NEW) {
                throw new IllegalStateException("Actor thread " + this.thread.getName() + " has not yet started.");
            }
            if (this.queue.hasWaitingConsumer() && this.queue.isEmpty()) {
                throw new IllegalStateException("There are no tasks running or queued up that we can wait for.");
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Thread.onSpinWait();
        }
    }

    @Override
    public void untilWaitingIn(Executable constructorOrMethod) throws InterruptedException {
        this.untilWaitingIn(ActorImpl.methodPredicate(constructorOrMethod));
    }

    @Override
    public void untilWaitingIn(String methodName) throws InterruptedException {
        this.untilWaitingIn(ActorImpl.methodPredicate(methodName));
    }

    private void untilWaitingIn(Predicate<StackTraceElement> predicate) throws InterruptedException {
        while (true) {
            this.untilWaiting();
            if (this.isIn(predicate)) {
                return;
            }
            Thread.sleep(1L);
        }
    }

    @Override
    public void untilThreadState(Thread.State ... states) {
        EnumSet<Thread.State> set = EnumSet.copyOf(Arrays.asList(states));
        Thread.State state;
        while (this.queue.hasWaitingConsumer() || !set.contains((Object)(state = this.thread.getState()))) {
            Thread.onSpinWait();
        }
        return;
    }

    @Override
    public void interrupt() {
        this.thread.interrupt();
    }

    private static Predicate<StackTraceElement> methodPredicate(Executable constructorOrMethod) {
        String targetMethodName = constructorOrMethod.getName();
        String targetClassName = constructorOrMethod.getDeclaringClass().getName();
        return element -> element.getMethodName().equals(targetMethodName) && element.getClassName().equals(targetClassName);
    }

    private static Predicate<StackTraceElement> methodPredicate(String methodName) {
        return element -> element.getMethodName().equals(methodName);
    }

    private boolean isIn(Predicate<StackTraceElement> predicate) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = this.thread.getStackTrace()) {
            if (!predicate.test(element)) continue;
            return true;
        }
        return false;
    }
}

