/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.matchers;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class CommonMatchers {
    private CommonMatchers() {
    }

    @SafeVarargs
    public static <T> Matcher<? super Iterable<T>> matchesOneToOneInAnyOrder(Matcher<? super T> ... expectedMatchers) {
        return new MatchesOneToOneInAnyOrder<T>(expectedMatchers);
    }

    private static class MatchesOneToOneInAnyOrder<T>
    extends TypeSafeMatcher<Iterable<T>> {
        private final Matcher<? super T>[] expectedMatchers;

        @SafeVarargs
        MatchesOneToOneInAnyOrder(Matcher<? super T> ... expectedMatchers) {
            this.expectedMatchers = expectedMatchers;
        }

        protected boolean matchesSafely(Iterable<T> items) {
            Set<Matcher<T>> matchers = this.uniqueMatchers();
            for (T item : items) {
                Matcher<T> matcherFound = null;
                for (Matcher<T> matcherConsidered : matchers) {
                    if (!matcherConsidered.matches(item)) continue;
                    if (matcherFound == null) {
                        matcherFound = matcherConsidered;
                        continue;
                    }
                    return false;
                }
                if (matcherFound == null) {
                    return false;
                }
                matchers.remove(matcherFound);
            }
            return matchers.isEmpty();
        }

        public void describeTo(Description description) {
            Set<Matcher<T>> matchers = this.uniqueMatchers();
            description.appendText("items that each match exactly one of ");
            description.appendList("{ ", ", ", " }", matchers);
            description.appendText(" and exactly as many items as matchers");
        }

        private Set<Matcher<? super T>> uniqueMatchers() {
            HashSet<Matcher<? super T>> matchers = new HashSet<Matcher<? super T>>();
            Collections.addAll(matchers, this.expectedMatchers);
            return matchers;
        }
    }
}

