/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.common.TokenNameLookup;

public class InMemoryTokens
implements TokenNameLookup {
    private final Map<Integer, String> labels = new HashMap<Integer, String>();
    private final Map<Integer, String> relationshipTypes = new HashMap<Integer, String>();
    private final Map<Integer, String> propertyKeys = new HashMap<Integer, String>();

    public String labelGetName(int labelId) {
        return this.labels.getOrDefault(labelId, "[" + labelId + "]");
    }

    public String relationshipTypeGetName(int relationshipTypeId) {
        return this.relationshipTypes.getOrDefault(relationshipTypeId, "[" + relationshipTypeId + "]");
    }

    public String propertyKeyGetName(int propertyKeyId) {
        return this.propertyKeys.getOrDefault(propertyKeyId, "[" + propertyKeyId + "]");
    }

    public InMemoryTokens label(int id, String name) {
        this.labels.put(id, name);
        return this;
    }

    public InMemoryTokens relationshipType(int id, String name) {
        this.relationshipTypes.put(id, name);
        return this;
    }

    public InMemoryTokens propertyKey(int id, String name) {
        this.propertyKeys.put(id, name);
        return this;
    }
}

