/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Unzip {
    private Unzip() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzip(Class<?> testClass, String resource, File targetDirectory) throws IOException {
        InputStream source = testClass.getResourceAsStream(resource);
        if (source == null) {
            throw new FileNotFoundException("Could not find resource '" + resource + "' to unzip");
        }
        try (ZipInputStream zipStream = new ZipInputStream(source);){
            ZipEntry entry;
            byte[] scratch = new byte[8096];
            while ((entry = zipStream.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    new File(targetDirectory, entry.getName()).mkdirs();
                } else {
                    try (BufferedOutputStream file = new BufferedOutputStream(new FileOutputStream(new File(targetDirectory, entry.getName())));){
                        int read;
                        while ((read = zipStream.read(scratch)) != -1) {
                            ((OutputStream)file).write(scratch, 0, read);
                        }
                    }
                }
                zipStream.closeEntry();
            }
        }
        finally {
            source.close();
        }
        return targetDirectory;
    }
}

