/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.ports;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

class PortRepository {
    private final Path directory;
    private int currentPort;

    PortRepository(Path directory, int initialPort) {
        this.directory = directory;
        this.currentPort = initialPort;
    }

    synchronized int reserveNextPort(String trace) {
        while (this.currentPort <= 65535) {
            Path portFilePath = this.directory.resolve("port" + this.currentPort);
            try {
                Files.createFile(portFilePath, new FileAttribute[0]);
                try (FileOutputStream fileOutputStream = new FileOutputStream(portFilePath.toFile(), true);){
                    fileOutputStream.write(trace.getBytes());
                    fileOutputStream.flush();
                }
                return this.currentPort++;
            }
            catch (FileAlreadyExistsException e) {
                ++this.currentPort;
            }
            catch (IOException e) {
                throw new IllegalStateException("This will never happen - LWN", e);
            }
        }
        throw new IllegalStateException("There are no more ports available");
    }
}

