/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.time.Duration;
import java.util.Objects;
import org.awaitility.Awaitility;
import org.awaitility.Durations;
import org.awaitility.core.ConditionTimeoutException;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseNotFoundException;
import org.neo4j.dbms.api.DatabaseNotFoundHelper;
import org.neo4j.graphdb.GraphDatabaseService;

public class AsyncDatabaseOperation {
    private AsyncDatabaseOperation() {
    }

    public static GraphDatabaseService findDatabaseEventually(DatabaseManagementService managementService, String databaseName) {
        return AsyncDatabaseOperation.findDatabaseEventually(managementService, databaseName, Durations.TWO_MINUTES);
    }

    public static GraphDatabaseService findDatabaseEventually(DatabaseManagementService managementService, String databaseName, Duration timeout) {
        try {
            return (GraphDatabaseService)Awaitility.await().atMost(timeout).ignoreException(DatabaseNotFoundException.class).between(Duration.ofMillis(50L), timeout).until(() -> AsyncDatabaseOperation.findDatabase(managementService, databaseName), Objects::nonNull);
        }
        catch (ConditionTimeoutException e) {
            throw DatabaseNotFoundHelper.databaseNotFound((String)databaseName);
        }
    }

    private static GraphDatabaseService findDatabase(DatabaseManagementService managementService, String databaseName) {
        GraphDatabaseService database = managementService.database(databaseName);
        return database.isAvailable() ? database : null;
    }
}

