/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.util.Optional;
import java.util.function.Predicate;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.neo4j.test.extension.SkipOnEnvironmentVariable;

public class SkipOnEnvironmentVariableExtension
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional envVariable = AnnotationUtils.findAnnotation((Optional)context.getElement(), SkipOnEnvironmentVariable.class).flatMap(a -> Optional.ofNullable(a.envVariable()).filter(Predicate.not(String::isEmpty)));
        if (envVariable.isPresent() && System.getenv().containsKey(envVariable.get())) {
            return ConditionEvaluationResult.disabled((String)("Test is disabled because you are running with " + (String)envVariable.get()));
        }
        return ConditionEvaluationResult.enabled((String)"Test is enabled");
    }
}

