/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension.netty;

import io.netty.util.ResourceLeakDetector;
import java.util.function.Supplier;

public class Neo4jLeakListener
implements ResourceLeakDetector.LeakListener {
    private static volatile String leakDescription;

    public void onLeak(String resourceType, String records) {
        leakDescription = records;
    }

    public static void checkLeaks(Supplier<String> testPlanDescriptionSupplier) {
        String description = leakDescription;
        if (description == null) {
            return;
        }
        String exceptionBuilder = "                                      ***WARNING***\nNetty buffer leak has been detected. The test session will be marked as failed.\nPlease review the details of unreleased allocations from the tests executed in the current session below.\nLast executed tests:\n" + testPlanDescriptionSupplier.get() + System.lineSeparator() + System.lineSeparator() + "Leak description:" + System.lineSeparator() + description;
        throw new RuntimeException(exceptionBuilder);
    }
}

