/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.extension;

import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.neo4j.io.memory.ByteBuffers;

public class Neo4jTestSessionCloseListener
implements LauncherSessionListener {
    private static final String MISSING_TEST_PLAN = "<Missing test plan>";
    private final ConcurrentHashMap<LauncherSession, TestPlan> sessions = new ConcurrentHashMap();

    public void launcherSessionOpened(final LauncherSession session) {
        session.getLauncher().registerTestExecutionListeners(new TestExecutionListener[]{new TestExecutionListener(){

            public void testPlanExecutionFinished(TestPlan testPlan) {
                Neo4jTestSessionCloseListener.this.sessions.put(session, testPlan);
            }
        }});
    }

    public void launcherSessionClosed(LauncherSession session) {
        TestPlan testPlan = this.sessions.remove(session);
        ByteBuffers.BUFFER_LEAK_TRACKER.checkLeaks(() -> this.describeTestPlan(testPlan));
    }

    String describeTestPlan(TestPlan testPlan) {
        if (testPlan == null) {
            return MISSING_TEST_PLAN;
        }
        final HashSet identifiers = new HashSet();
        testPlan.accept(new TestPlan.Visitor(){

            public void visit(TestIdentifier testIdentifier) {
                if (testIdentifier.isTest()) {
                    identifiers.add(testIdentifier.getUniqueId());
                }
            }
        });
        return identifiers.stream().sorted().collect(Collectors.joining(System.lineSeparator()));
    }
}

