/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.internal.helpers.collection.ArrayIterator;

public abstract class PropertyTypeDispatcher<K, T> {
    public static void consumeProperties(PropertyTypeDispatcher<String, Void> dispatcher, Entity entity) {
        for (Map.Entry property : entity.getAllProperties().entrySet()) {
            dispatcher.dispatch(property.getValue(), (String)property.getKey());
        }
    }

    public final T dispatch(Object property, K param) {
        if (property == null) {
            return this.dispatchNullProperty();
        }
        if (property instanceof String) {
            return this.dispatchStringProperty((String)property, param);
        }
        if (property instanceof Number) {
            return this.dispatchNumberProperty((Number)property, param);
        }
        if (property instanceof Boolean) {
            return this.dispatchBooleanProperty((Boolean)property, param);
        }
        if (property instanceof Character) {
            return this.dispatchCharacterProperty(((Character)property).charValue(), param);
        }
        if (property instanceof Point) {
            return this.dispatchPointProperty((Point)property, param);
        }
        if (property instanceof Temporal) {
            return this.dispatchTemporalProperty((Temporal)property, param);
        }
        if (property instanceof TemporalAmount) {
            return this.dispatchTemporalAmountProperty((TemporalAmount)property, param);
        }
        if (property instanceof String[]) {
            return this.dispatchStringArrayProperty((String[])property, param);
        }
        if (property instanceof Point[]) {
            return this.dispatchPointArrayProperty((Point[])property, param);
        }
        if (property instanceof Temporal[]) {
            return this.dispatchTemporalArrayProperty((Temporal[])property, param);
        }
        if (property instanceof TemporalAmount[]) {
            return this.dispatchTemporalAmountArrayProperty((TemporalAmount[])property, param);
        }
        if (property instanceof List) {
            return this.dispatchList((List)property, param);
        }
        if (property instanceof Object[]) {
            return this.dispatchOtherArray((Object[])property, param);
        }
        Class<?> propertyType = property.getClass();
        if (propertyType.isArray() && propertyType.getComponentType().isPrimitive()) {
            return this.dispatchPrimitiveArray(property, param);
        }
        return this.dispatchOtherProperty(property);
    }

    private T dispatchList(List propertyList, K param) {
        Object peekedItem = propertyList.get(0);
        if (peekedItem == null) {
            return this.dispatchNullProperty();
        }
        if (peekedItem instanceof String) {
            String[] convertedArray = new String[propertyList.size()];
            for (int i = 0; i < propertyList.size(); ++i) {
                convertedArray[i] = (String)propertyList.get(i);
            }
            return this.dispatch(convertedArray, param);
        }
        if (peekedItem instanceof Number) {
            Number[] convertedArray = new Number[propertyList.size()];
            for (int i = 0; i < propertyList.size(); ++i) {
                convertedArray[i] = (Number)propertyList.get(i);
            }
            return this.dispatch(convertedArray, param);
        }
        if (peekedItem instanceof Boolean) {
            Boolean[] convertedArray = new Boolean[propertyList.size()];
            for (int i = 0; i < propertyList.size(); ++i) {
                convertedArray[i] = (Boolean)propertyList.get(i);
            }
            return this.dispatch(convertedArray, param);
        }
        if (peekedItem instanceof Character) {
            Character[] convertedArray = new Character[propertyList.size()];
            for (int i = 0; i < propertyList.size(); ++i) {
                convertedArray[i] = (Character)propertyList.get(i);
            }
            return this.dispatch(convertedArray, param);
        }
        if (peekedItem instanceof Point) {
            Point[] convertedArray = new Point[propertyList.size()];
            for (int i = 0; i < propertyList.size(); ++i) {
                convertedArray[i] = (Point)propertyList.get(i);
            }
            return this.dispatch(convertedArray, param);
        }
        if (peekedItem instanceof Temporal) {
            Temporal[] convertedArray = new Temporal[propertyList.size()];
            for (int i = 0; i < propertyList.size(); ++i) {
                convertedArray[i] = (Temporal)propertyList.get(i);
            }
            return this.dispatch(convertedArray, param);
        }
        if (peekedItem instanceof TemporalAmount) {
            TemporalAmount[] convertedArray = new TemporalAmount[propertyList.size()];
            for (int i = 0; i < propertyList.size(); ++i) {
                convertedArray[i] = (TemporalAmount)propertyList.get(i);
            }
            return this.dispatch(convertedArray, param);
        }
        return this.dispatchOtherProperty(propertyList);
    }

    private T dispatchPrimitiveArray(Object property, K param) {
        if (property instanceof byte[]) {
            return this.dispatchByteArrayProperty((byte[])property, param);
        }
        if (property instanceof char[]) {
            return this.dispatchCharacterArrayProperty((char[])property, param);
        }
        if (property instanceof boolean[]) {
            return this.dispatchBooleanArrayProperty((boolean[])property, param);
        }
        if (property instanceof long[]) {
            return this.dispatchLongArrayProperty((long[])property, param);
        }
        if (property instanceof double[]) {
            return this.dispatchDoubleArrayProperty((double[])property, param);
        }
        if (property instanceof int[]) {
            return this.dispatchIntegerArrayProperty((int[])property, param);
        }
        if (property instanceof short[]) {
            return this.dispatchShortArrayProperty((short[])property, param);
        }
        if (property instanceof float[]) {
            return this.dispatchFloatArrayProperty((float[])property, param);
        }
        throw new Error("Unsupported primitive array type: " + property.getClass());
    }

    private T dispatchOtherArray(Object[] property, K param) {
        if (property instanceof Byte[]) {
            return this.dispatchByteArrayProperty((Byte[])property, param);
        }
        if (property instanceof Character[]) {
            return this.dispatchCharacterArrayProperty((Character[])property, param);
        }
        if (property instanceof Boolean[]) {
            return this.dispatchBooleanArrayProperty((Boolean[])property, param);
        }
        if (property instanceof Long[]) {
            return this.dispatchLongArrayProperty((Long[])property, param);
        }
        if (property instanceof Double[]) {
            return this.dispatchDoubleArrayProperty((Double[])property, param);
        }
        if (property instanceof Integer[]) {
            return this.dispatchIntegerArrayProperty((Integer[])property, param);
        }
        if (property instanceof Short[]) {
            return this.dispatchShortArrayProperty((Short[])property, param);
        }
        if (property instanceof Float[]) {
            return this.dispatchFloatArrayProperty((Float[])property, param);
        }
        throw new IllegalArgumentException("Unsupported property array type: " + property.getClass());
    }

    private T dispatchNumberProperty(Number property, K param) {
        if (property instanceof Long) {
            return this.dispatchLongProperty((Long)property, param);
        }
        if (property instanceof Integer) {
            return this.dispatchIntegerProperty((Integer)property, param);
        }
        if (property instanceof Double) {
            return this.dispatchDoubleProperty((Double)property, param);
        }
        if (property instanceof Float) {
            return this.dispatchFloatProperty(((Float)property).floatValue(), param);
        }
        if (property instanceof Short) {
            return this.dispatchShortProperty((Short)property, param);
        }
        if (property instanceof Byte) {
            return this.dispatchByteProperty((Byte)property, param);
        }
        throw new IllegalArgumentException("Unsupported property type: " + property.getClass());
    }

    private T dispatchNullProperty() {
        return null;
    }

    protected abstract T dispatchByteProperty(byte var1, K var2);

    protected abstract T dispatchCharacterProperty(char var1, K var2);

    protected abstract T dispatchShortProperty(short var1, K var2);

    protected abstract T dispatchIntegerProperty(int var1, K var2);

    protected abstract T dispatchLongProperty(long var1, K var3);

    protected abstract T dispatchFloatProperty(float var1, K var2);

    protected abstract T dispatchDoubleProperty(double var1, K var3);

    protected abstract T dispatchBooleanProperty(boolean var1, K var2);

    protected T dispatchPointProperty(Point property, K param) {
        return this.dispatchOtherProperty(property);
    }

    protected T dispatchTemporalProperty(Temporal property, K param) {
        return this.dispatchOtherProperty(property);
    }

    protected T dispatchTemporalAmountProperty(TemporalAmount property, K param) {
        return this.dispatchOtherProperty(property);
    }

    private T dispatchOtherProperty(Object property) {
        throw new IllegalArgumentException("Unsupported property type: " + property.getClass());
    }

    private T dispatchByteArrayProperty(final byte[] property, K param) {
        return this.dispatchByteArrayProperty((PropertyArray<Byte>)new PrimitiveArray<Byte>(){

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Byte item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    private T dispatchCharacterArrayProperty(final char[] property, K param) {
        return this.dispatchCharacterArrayProperty((PropertyArray<Character>)new PrimitiveArray<Character>(){

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Character item(int offset) {
                return Character.valueOf(property[offset]);
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    private T dispatchShortArrayProperty(final short[] property, K param) {
        return this.dispatchShortArrayProperty((PropertyArray<Short>)new PrimitiveArray<Short>(){

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Short item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    private T dispatchIntegerArrayProperty(final int[] property, K param) {
        return this.dispatchIntegerArrayProperty((PropertyArray<Integer>)new PrimitiveArray<Integer>(){

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Integer item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    private T dispatchLongArrayProperty(final long[] property, K param) {
        return this.dispatchLongArrayProperty((PropertyArray<Long>)new PrimitiveArray<Long>(){

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Long item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    private T dispatchFloatArrayProperty(final float[] property, K param) {
        return this.dispatchFloatArrayProperty((PropertyArray<Float>)new PrimitiveArray<Float>(){

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Float item(int offset) {
                return Float.valueOf(property[offset]);
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    private T dispatchDoubleArrayProperty(final double[] property, K param) {
        return this.dispatchDoubleArrayProperty((PropertyArray<Double>)new PrimitiveArray<Double>(){

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Double item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    private T dispatchBooleanArrayProperty(final boolean[] property, K param) {
        return this.dispatchBooleanArrayProperty((PropertyArray<Boolean>)new PrimitiveArray<Boolean>(){

            @Override
            public int length() {
                return property.length;
            }

            @Override
            protected Boolean item(int offset) {
                return property[offset];
            }

            @Override
            public Class<?> getType() {
                return property.getClass();
            }
        }, param);
    }

    private T dispatchByteArrayProperty(Byte[] property, K param) {
        return this.dispatchByteArrayProperty(new BoxedArray<Byte>(property), param);
    }

    private T dispatchCharacterArrayProperty(Character[] property, K param) {
        return this.dispatchCharacterArrayProperty(new BoxedArray<Character>(property), param);
    }

    private T dispatchShortArrayProperty(Short[] property, K param) {
        return this.dispatchShortArrayProperty(new BoxedArray<Short>(property), param);
    }

    private T dispatchIntegerArrayProperty(Integer[] property, K param) {
        return this.dispatchIntegerArrayProperty(new BoxedArray<Integer>(property), param);
    }

    private T dispatchLongArrayProperty(Long[] property, K param) {
        return this.dispatchLongArrayProperty(new BoxedArray<Long>(property), param);
    }

    private T dispatchFloatArrayProperty(Float[] property, K param) {
        return this.dispatchFloatArrayProperty(new BoxedArray<Float>(property), param);
    }

    private T dispatchDoubleArrayProperty(Double[] property, K param) {
        return this.dispatchDoubleArrayProperty(new BoxedArray<Double>(property), param);
    }

    private T dispatchBooleanArrayProperty(Boolean[] property, K param) {
        return this.dispatchBooleanArrayProperty(new BoxedArray<Boolean>(property), param);
    }

    protected abstract T dispatchStringProperty(String var1, K var2);

    protected T dispatchStringArrayProperty(String[] property, K param) {
        return this.dispatchStringArrayProperty(new BoxedArray<String>(property), param);
    }

    private T dispatchStringArrayProperty(PropertyArray<String> array, K param) {
        return this.dispatchArray(array);
    }

    protected T dispatchPointArrayProperty(Point[] property, K param) {
        return this.dispatchPointArrayProperty(new BoxedArray<Point>(property), param);
    }

    private T dispatchPointArrayProperty(PropertyArray<Point> array, K param) {
        return this.dispatchArray(array);
    }

    private T dispatchTemporalArrayProperty(PropertyArray<Temporal> array, K param) {
        return this.dispatchArray(array);
    }

    protected T dispatchTemporalArrayProperty(Temporal[] property, K param) {
        return this.dispatchTemporalArrayProperty(new BoxedArray<Temporal>(property), param);
    }

    private T dispatchTemporalAmountArrayProperty(PropertyArray<TemporalAmount> array, K param) {
        return this.dispatchArray(array);
    }

    protected T dispatchTemporalAmountArrayProperty(TemporalAmount[] property, K param) {
        return this.dispatchTemporalAmountArrayProperty(new BoxedArray<TemporalAmount>(property), param);
    }

    protected T dispatchByteArrayProperty(PropertyArray<Byte> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchCharacterArrayProperty(PropertyArray<Character> array, K param) {
        return this.dispatchArray(array);
    }

    protected T dispatchShortArrayProperty(PropertyArray<Short> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchIntegerArrayProperty(PropertyArray<Integer> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchLongArrayProperty(PropertyArray<Long> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchFloatArrayProperty(PropertyArray<Float> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchDoubleArrayProperty(PropertyArray<Double> array, K param) {
        return this.dispatchNumberArray(array, param);
    }

    protected T dispatchBooleanArrayProperty(PropertyArray<Boolean> array, K param) {
        return this.dispatchArray(array);
    }

    private T dispatchNumberArray(PropertyArray<? extends Number> array, K param) {
        return this.dispatchArray(array);
    }

    private T dispatchArray(PropertyArray<?> array) {
        throw new UnsupportedOperationException("Unhandled array type: " + array.getType());
    }

    public static interface PropertyArray<T>
    extends Iterable<T> {
        public int length();

        public Class<?> getType();
    }

    private static final class BoxedArray<T>
    implements PropertyArray<T> {
        private final T[] array;

        BoxedArray(T[] array) {
            this.array = array;
        }

        @Override
        public int length() {
            return this.array.length;
        }

        @Override
        public Iterator<T> iterator() {
            return new ArrayIterator((Object[])this.array);
        }

        @Override
        public Class<?> getType() {
            return this.array.getClass();
        }
    }

    private static abstract class PrimitiveArray<T>
    implements PropertyArray<T> {
        private PrimitiveArray() {
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                final int size;
                int pos;
                {
                    this.size = this.length();
                }

                @Override
                public boolean hasNext() {
                    return this.pos < this.size;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.item(this.pos++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Cannot remove element from primitive array.");
                }
            };
        }

        protected abstract T item(int var1);
    }
}

