/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.plugins;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.helpers.Service;
import org.neo4j.server.plugins.PluginPoint;
import org.neo4j.server.plugins.PluginPointFactory;
import org.neo4j.server.plugins.PluginTarget;
import org.neo4j.server.plugins.ServerExtender;

public abstract class ServerPlugin {
    final String name;

    public ServerPlugin(String name) {
        this.name = ServerPlugin.verifyName(name);
    }

    public ServerPlugin() {
        this.name = ServerPlugin.verifyName(this.getClass().getSimpleName());
    }

    static String verifyName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name may not be null");
        }
        try {
            if (!URLEncoder.encode(name, StandardCharsets.UTF_8.name()).equals(name)) {
                throw new IllegalArgumentException("Name contains illegal characters");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 should be supported", e);
        }
        return name;
    }

    public String toString() {
        return "ServerPlugin[" + this.name + "]";
    }

    static Iterable<ServerPlugin> load() {
        return Service.load(ServerPlugin.class);
    }

    protected void loadServerExtender(ServerExtender extender) {
        for (PluginPoint plugin : this.getDefaultExtensionPoints(extender.getPluginPointFactory())) {
            extender.addExtension(plugin.forType(), plugin);
        }
    }

    protected Collection<PluginPoint> getDefaultExtensionPoints(PluginPointFactory pluginPointFactory) {
        ArrayList<PluginPoint> result = new ArrayList<PluginPoint>();
        for (Method method : this.getClass().getMethods()) {
            PluginTarget target = method.getAnnotation(PluginTarget.class);
            if (target == null) continue;
            result.add(pluginPointFactory.createFrom(this, method, target.value()));
        }
        return result;
    }
}

