/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.util.Util;
import java.util.Collections;
import java.util.Map;

public class LoadHtmlConfig {
    private final String driverVersion;
    private final String browserVersion;
    private final String architecture;
    private final String operatingSystem;
    private final String driverRepositoryUrl;
    private final String versionsPropertiesUrl;
    private final String commandsPropertiesUrl;
    private final String cachePath;
    private final String resolutionCachePath;
    private final String proxy;
    private final String proxyUser;
    private final String proxyPass;
    private final String gitHubToken;
    private final Integer ttlBrowsers;
    private final Integer timeout;
    private final boolean useLocalVersionsPropertiesFirst;
    private final boolean clearDriverCache;
    private final boolean forceDownload;
    private final boolean avoidExport;
    private final boolean avoidReadReleaseFromRepository;
    private final boolean useBetaVersions;
    private final boolean useMirror;
    private final boolean clearResolutionCache;
    private final Integer ttl;
    private final boolean avoidOutputTree;
    private final boolean avoidFallback;
    private final boolean avoidBrowserDetection;
    private final boolean avoidTmpFolder;
    private final boolean headless;
    private final boolean acceptInsecureCerts;
    private final boolean children;
    private final boolean htmlString;
    private final String charset;
    private final String baseUri;
    private final Browser browser;
    private final FailSilently failSilently;
    private final long wait;
    private final int textSize;

    public LoadHtmlConfig(Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.headless = Util.toBoolean((Object)config.getOrDefault("headless", true));
        this.acceptInsecureCerts = Util.toBoolean((Object)config.getOrDefault("acceptInsecureCerts", true));
        this.children = Util.toBoolean((Object)config.get("children"));
        this.charset = (String)config.getOrDefault("charset", "UTF-8");
        this.baseUri = (String)config.getOrDefault("baseUri", "");
        this.browser = Browser.valueOf((String)config.getOrDefault("browser", Browser.NONE.toString()));
        this.failSilently = FailSilently.valueOf((String)config.getOrDefault("failSilently", FailSilently.FALSE.toString()));
        this.wait = Util.toLong((Object)config.getOrDefault("wait", 0));
        this.textSize = Util.toInteger((Object)config.getOrDefault("textSize", 80));
        this.htmlString = Util.toBoolean((Object)config.get("htmlString"));
        this.driverVersion = (String)config.get("driverVersion");
        this.browserVersion = (String)config.get("browserVersion");
        this.architecture = (String)config.get("architecture");
        this.operatingSystem = (String)config.get("operatingSystem");
        this.driverRepositoryUrl = (String)config.get("driverRepositoryUrl");
        this.versionsPropertiesUrl = (String)config.get("versionsPropertiesUrl");
        this.commandsPropertiesUrl = (String)config.get("commandsPropertiesUrl");
        this.cachePath = (String)config.get("cachePath");
        this.resolutionCachePath = (String)config.get("resolutionCachePath");
        this.proxy = (String)config.get("proxy");
        this.proxyUser = (String)config.get("proxyUser");
        this.proxyPass = (String)config.get("proxyPass");
        this.gitHubToken = (String)config.get("gitHubToken");
        this.forceDownload = Util.toBoolean((Object)config.get("forceDownload"));
        this.useBetaVersions = Util.toBoolean((Object)config.get("useBetaVersions"));
        this.useMirror = Util.toBoolean((Object)config.get("useMirror"));
        this.avoidExport = Util.toBoolean((Object)config.get("avoidExport"));
        this.avoidOutputTree = Util.toBoolean((Object)config.get("avoidOutputTree"));
        this.clearDriverCache = Util.toBoolean((Object)config.get("clearDriverCache"));
        this.clearResolutionCache = Util.toBoolean((Object)config.get("clearResolutionCache"));
        this.avoidFallback = Util.toBoolean((Object)config.get("avoidFallback"));
        this.avoidBrowserDetection = Util.toBoolean((Object)config.get("avoidBrowserDetection"));
        this.avoidReadReleaseFromRepository = Util.toBoolean((Object)config.get("avoidReadReleaseFromRepository"));
        this.avoidTmpFolder = Util.toBoolean((Object)config.get("avoidTmpFolder"));
        this.useLocalVersionsPropertiesFirst = Util.toBoolean((Object)config.get("useLocalVersionsPropertiesFirst"));
        this.timeout = Util.toInteger((Object)config.get("timeout"));
        this.ttl = Util.toInteger((Object)config.get("ttl"));
        this.ttlBrowsers = Util.toInteger((Object)config.get("ttlBrowsers"));
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public boolean isAcceptInsecureCerts() {
        return this.acceptInsecureCerts;
    }

    public boolean isChildren() {
        return this.children;
    }

    public boolean isHtmlString() {
        return this.htmlString;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public FailSilently getFailSilently() {
        return this.failSilently;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public long getWait() {
        return this.wait;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public String getBrowserVersion() {
        return this.browserVersion;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getDriverRepositoryUrl() {
        return this.driverRepositoryUrl;
    }

    public String getVersionsPropertiesUrl() {
        return this.versionsPropertiesUrl;
    }

    public String getCommandsPropertiesUrl() {
        return this.commandsPropertiesUrl;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public String getResolutionCachePath() {
        return this.resolutionCachePath;
    }

    public String getProxy() {
        return this.proxy;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public Integer getTtlBrowsers() {
        return this.ttlBrowsers;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public String getGitHubToken() {
        return this.gitHubToken;
    }

    public boolean isUseLocalVersionsPropertiesFirst() {
        return this.useLocalVersionsPropertiesFirst;
    }

    public boolean isClearDriverCache() {
        return this.clearDriverCache;
    }

    public boolean isForceDownload() {
        return this.forceDownload;
    }

    public boolean isAvoidExport() {
        return this.avoidExport;
    }

    public boolean isAvoidReadReleaseFromRepository() {
        return this.avoidReadReleaseFromRepository;
    }

    public boolean isUseBetaVersions() {
        return this.useBetaVersions;
    }

    public boolean isUseMirror() {
        return this.useMirror;
    }

    public boolean isClearResolutionCache() {
        return this.clearResolutionCache;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public boolean isAvoidOutputTree() {
        return this.avoidOutputTree;
    }

    public boolean isAvoidFallback() {
        return this.avoidFallback;
    }

    public boolean isAvoidBrowserDetection() {
        return this.avoidBrowserDetection;
    }

    public boolean isAvoidTmpFolder() {
        return this.avoidTmpFolder;
    }

    static enum FailSilently {
        FALSE,
        WITH_LOG,
        WITH_LIST;

    }

    static enum Browser {
        NONE,
        CHROME,
        FIREFOX;

    }
}

