/*
 * Decompiled with CFR 0.152.
 */
package apoc.custom;

import apoc.Extended;
import apoc.custom.CypherProceduresHandler;
import apoc.custom.Signatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.graphdb.Notification;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.graphdb.Result;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.UserFunctionSignature;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
public class CypherProcedures {
    public static final String ERROR_MISMATCHED_INPUTS = "Required query parameters do not match provided input arguments.";
    public static final String ERROR_MISMATCHED_OUTPUTS = "Query results do not match requested output.";
    @Context
    public GraphDatabaseAPI api;
    @Context
    public KernelTransaction ktx;
    @Context
    public Log log;
    @Context
    public CypherProceduresHandler cypherProceduresHandler;

    @Procedure(value="apoc.custom.asProcedure", mode=Mode.WRITE, deprecatedBy="apoc.custom.declareProcedure")
    @Description(value="apoc.custom.asProcedure(name, statement, mode, outputs, inputs, description) - register a custom cypher procedure")
    @Deprecated
    public void asProcedure(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="mode", defaultValue="read") String mode, @Name(value="outputs", defaultValue="null") List<List<String>> outputs, @Name(value="inputs", defaultValue="null") List<List<String>> inputs, @Name(value="description", defaultValue="") String description) throws ProcedureException {
        ProcedureSignature signature = this.cypherProceduresHandler.procedureSignature(name, mode, outputs, inputs, description);
        Mode modeProcedure = this.cypherProceduresHandler.mode(mode);
        this.validateProcedure(statement, signature.inputSignature(), signature.outputSignature(), modeProcedure);
        this.cypherProceduresHandler.storeProcedure(signature, statement);
    }

    @Procedure(value="apoc.custom.declareProcedure", mode=Mode.WRITE)
    @Description(value="apoc.custom.declareProcedure(signature, statement, mode, description) - register a custom cypher procedure")
    public void declareProcedure(@Name(value="signature") String signature, @Name(value="statement") String statement, @Name(value="mode", defaultValue="read") String mode, @Name(value="description", defaultValue="") String description) {
        Mode modeProcedure = this.cypherProceduresHandler.mode(mode);
        ProcedureSignature procedureSignature = new Signatures("custom").asProcedureSignature(signature, description, modeProcedure);
        this.validateProcedure(statement, procedureSignature.inputSignature(), procedureSignature.outputSignature(), modeProcedure);
        if (!this.cypherProceduresHandler.registerProcedure(procedureSignature, statement)) {
            throw new IllegalStateException("Error registering procedure " + procedureSignature.name() + ", see log.");
        }
        this.cypherProceduresHandler.storeProcedure(procedureSignature, statement);
    }

    @Procedure(value="apoc.custom.asFunction", mode=Mode.WRITE, deprecatedBy="apoc.custom.declareFunction")
    @Description(value="apoc.custom.asFunction(name, statement, outputs, inputs, forceSingle, description) - register a custom cypher function")
    @Deprecated
    public void asFunction(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="outputs", defaultValue="") String output, @Name(value="inputs", defaultValue="null") List<List<String>> inputs, @Name(value="forceSingle", defaultValue="false") boolean forceSingle, @Name(value="description", defaultValue="") String description) throws ProcedureException {
        UserFunctionSignature signature = this.cypherProceduresHandler.functionSignature(name, output, inputs, description);
        this.validateFunction(statement, signature.inputSignature());
        this.cypherProceduresHandler.storeFunction(signature, statement, forceSingle);
    }

    @Procedure(value="apoc.custom.declareFunction", mode=Mode.WRITE)
    @Description(value="apoc.custom.declareFunction(signature, statement, forceSingle, description) - register a custom cypher function")
    public void declareFunction(@Name(value="signature") String signature, @Name(value="statement") String statement, @Name(value="forceSingle", defaultValue="false") boolean forceSingle, @Name(value="description", defaultValue="") String description) throws ProcedureException {
        UserFunctionSignature userFunctionSignature = new Signatures("custom").asFunctionSignature(signature, description);
        this.validateFunction(statement, userFunctionSignature.inputSignature());
        if (!this.cypherProceduresHandler.registerFunction(userFunctionSignature, statement, forceSingle)) {
            throw new IllegalStateException("Error registering function " + signature + ", see log.");
        }
        this.cypherProceduresHandler.storeFunction(userFunctionSignature, statement, forceSingle);
    }

    @Procedure(value="apoc.custom.list", mode=Mode.READ)
    @Description(value="apoc.custom.list() - provide a list of custom procedures/function registered")
    public Stream<CustomProcedureInfo> list() {
        return this.cypherProceduresHandler.readSignatures().map(descriptor -> {
            if (descriptor instanceof CypherProceduresHandler.ProcedureDescriptor) {
                CypherProceduresHandler.ProcedureDescriptor procedureDescriptor = (CypherProceduresHandler.ProcedureDescriptor)descriptor;
                ProcedureSignature signature = procedureDescriptor.getSignature();
                return new CustomProcedureInfo("procedure", signature.name().toString().substring("custom".length() + 1), signature.description().orElse(null), signature.mode().toString().toLowerCase(), procedureDescriptor.getStatement(), this.convertInputSignature(signature.inputSignature()), Iterables.asList((Iterable)Iterables.map(f -> Arrays.asList(f.name(), this.prettyPrintType(f.neo4jType())), (Iterable)signature.outputSignature())), null);
            }
            CypherProceduresHandler.UserFunctionDescriptor userFunctionDescriptor = (CypherProceduresHandler.UserFunctionDescriptor)descriptor;
            UserFunctionSignature signature = userFunctionDescriptor.getSignature();
            return new CustomProcedureInfo("function", signature.name().toString().substring("custom".length() + 1), signature.description().orElse(null), null, userFunctionDescriptor.getStatement(), this.convertInputSignature(signature.inputSignature()), this.prettyPrintType(signature.outputType()), userFunctionDescriptor.isForceSingle());
        });
    }

    @Procedure(value="apoc.custom.removeProcedure", mode=Mode.WRITE)
    @Description(value="apoc.custom.removeProcedure(name) - remove the targeted custom procedure")
    public void removeProcedure(@Name(value="name") String name) {
        Objects.requireNonNull(name, "name");
        this.cypherProceduresHandler.removeProcedure(name);
    }

    @Procedure(value="apoc.custom.removeFunction", mode=Mode.WRITE)
    @Description(value="apoc.custom.removeFunction(name, type) - remove the targeted custom function")
    public void removeFunction(@Name(value="name") String name) {
        Objects.requireNonNull(name, "name");
        this.cypherProceduresHandler.removeFunction(name);
    }

    private void validateFunction(String statement, List<FieldSignature> input) {
        this.validateProcedure(statement, input, CypherProceduresHandler.DEFAULT_MAP_OUTPUT, null);
    }

    private void validateProcedure(String statement, List<FieldSignature> input, List<FieldSignature> output, Mode mode) {
        Set outputSet = output.stream().map(FieldSignature::name).collect(Collectors.toSet());
        this.api.executeTransactionally("EXPLAIN " + statement, (Map)input.stream().collect(HashMap::new, (map, value) -> map.put(value.name(), null), HashMap::putAll), result -> {
            if (!CypherProceduresHandler.DEFAULT_MAP_OUTPUT.equals(output)) {
                Set<String> columns = result.columns().stream().map(i -> i.replaceFirst("@[0-9]+", "").trim()).collect(Collectors.toSet());
                this.checkOutputParams(outputSet, columns);
            }
            if (!CypherProceduresHandler.DEFAULT_INPUTS.equals(input)) {
                this.checkInputParams((Result)result);
            }
            if (mode != null) {
                this.checkMode(result.getQueryExecutionType().queryType(), mode);
            }
            return null;
        });
    }

    private void checkMode(QueryExecutionType.QueryType queryType, Mode mode) {
        Map<QueryExecutionType.QueryType, Mode> map = Map.of(QueryExecutionType.QueryType.WRITE, Mode.WRITE, QueryExecutionType.QueryType.READ_ONLY, Mode.READ, QueryExecutionType.QueryType.READ_WRITE, Mode.WRITE);
        if (!map.get(queryType).equals((Object)mode)) {
            throw new RuntimeException(String.format("The query execution type is %s, but you provided mode %s.\nSupported modes are %s", queryType.name(), mode.name(), map.values().stream().sorted().collect(Collectors.toList()).toString()));
        }
    }

    private void checkOutputParams(Set<String> outputSet, Set<String> columns) {
        if (!Set.copyOf(columns).equals(outputSet)) {
            throw new RuntimeException(ERROR_MISMATCHED_OUTPUTS);
        }
    }

    private void checkInputParams(Result result) {
        String missingParameters = StreamSupport.stream(result.getNotifications().spliterator(), false).filter(i -> i.getCode().equals(Status.Statement.ParameterMissing.code().serialize())).map(Notification::getDescription).collect(Collectors.joining(System.lineSeparator()));
        if (StringUtils.isNotBlank((CharSequence)missingParameters)) {
            throw new RuntimeException(ERROR_MISMATCHED_INPUTS);
        }
    }

    private List<List<String>> convertInputSignature(List<FieldSignature> signatures) {
        return Iterables.asList((Iterable)Iterables.map(f -> {
            ArrayList<String> list = new ArrayList<String>(3);
            list.add(f.name());
            list.add(this.prettyPrintType(f.neo4jType()));
            Optional defaultParameterValue = f.defaultValue();
            defaultParameterValue.map(DefaultParameterValue::value).ifPresent(v -> list.add(v.toString()));
            return list;
        }, signatures));
    }

    private String prettyPrintType(Neo4jTypes.AnyType type) {
        String s = type.toString().toLowerCase();
        if (s.endsWith("?")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static class CustomProcedureInfo {
        public String type;
        public String name;
        public String description;
        public String mode;
        public String statement;
        public List<List<String>> inputs;
        public Object outputs;
        public Boolean forceSingle;

        public CustomProcedureInfo(String type, String name, String description, String mode, String statement, List<List<String>> inputs, Object outputs, Boolean forceSingle) {
            this.type = type;
            this.name = name;
            this.description = description;
            this.statement = statement;
            this.outputs = outputs;
            this.inputs = inputs;
            this.forceSingle = forceSingle;
            this.mode = mode;
        }
    }
}

