/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase;

import apoc.ApocConfig;
import apoc.util.Util;
import com.couchbase.client.core.env.CompressionConfig;
import com.couchbase.client.core.env.IoConfig;
import com.couchbase.client.core.env.IoEnvironment;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.env.SecurityConfig;
import com.couchbase.client.core.env.TimeoutConfig;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.FailFastRetryStrategy;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.java.codec.RawBinaryTranscoder;
import com.couchbase.client.java.codec.RawJsonTranscoder;
import com.couchbase.client.java.codec.RawStringTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterEnvironment;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;

public class CouchbaseConfig {
    private static final Map<String, Object> DEFAULT_CONFIG = Map.of("connectTimeout", 5000L, "kvTimeout", 2500, "ioPoolSize", 3);
    private final String collection;
    private final String scope;
    private final Long connectTimeout;
    private final Long kvTimeout;
    private final long queryTimeout;
    private final long analyticsTimeout;
    private final long disconnectTimeout;
    private final long viewTimeout;
    private final long searchTimeout;
    private final Integer compressionMinSize;
    private final Double compressionMinRatio;
    private final boolean compressionEnabled;
    private final boolean mutationTokensEnabled;
    private final RetryStrategy retryStrategy;
    private final Transcoder transcoder;
    private final long configPollInterval;
    private final long idleHttpConnectionTimeout;
    private final long tcpKeepAliveTime;
    private final boolean enableDnsSrv;
    private final boolean enableTcpKeepAlives;
    private final NetworkResolution networkResolution;
    private final String trustCertificate;
    private final Long waitUntilReady;

    public CouchbaseConfig(Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.collection = (String)config.getOrDefault("collection", "_default");
        this.scope = (String)config.getOrDefault("scope", "_default");
        this.compressionMinSize = Util.toInteger((Object)config.getOrDefault("compressionMinSize", 32));
        this.compressionMinRatio = Util.toDouble((Object)config.getOrDefault("compressionMinRatio", 0.83));
        this.compressionEnabled = Util.toBoolean((Object)config.getOrDefault("compressionEnabled", true));
        this.mutationTokensEnabled = Util.toBoolean((Object)config.getOrDefault("mutationTokensEnabled", true));
        this.retryStrategy = RetryConfig.valueOf(config.getOrDefault("retryStrategy", RetryConfig.BESTEFFORT.name()).toString().toUpperCase()).getInstance();
        this.transcoder = TrancoderConfig.valueOf(config.getOrDefault("transcoder", TrancoderConfig.DEFAULT.name()).toString().toUpperCase()).getInstance();
        this.connectTimeout = Util.toLong((Object)config.get("connectTimeout"));
        this.kvTimeout = Util.toLong((Object)config.get("kvTimeout"));
        this.disconnectTimeout = Util.toLong((Object)config.getOrDefault("disconnectTimeout", 10000L));
        this.queryTimeout = Util.toLong((Object)config.getOrDefault("queryTimeout", 75000L));
        this.analyticsTimeout = Util.toLong((Object)config.getOrDefault("analyticsTimeout", 75000L));
        this.viewTimeout = Util.toLong((Object)config.getOrDefault("viewTimeout", 75000L));
        this.searchTimeout = Util.toLong((Object)config.getOrDefault("searchTimeout", 75000L));
        this.configPollInterval = Util.toLong((Object)config.getOrDefault("configPollInterval", 2500L));
        this.idleHttpConnectionTimeout = Util.toLong((Object)config.getOrDefault("idleHttpConnectionTimeout", 4500L));
        this.tcpKeepAliveTime = Util.toLong((Object)config.getOrDefault("tcpKeepAliveTime", 60000L));
        this.enableDnsSrv = Util.toBoolean((Object)config.getOrDefault("enableDnsSrv", true));
        this.enableTcpKeepAlives = Util.toBoolean((Object)config.getOrDefault("enableTcpKeepAlives", true));
        this.networkResolution = NetworkResolution.valueOf((String)((String)config.get("networkResolution")));
        this.trustCertificate = (String)config.get("trustCertificate");
        this.waitUntilReady = Util.toLong((Object)config.get("waitUntilReady"));
    }

    public Integer getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public Double getCompressionMinRatio() {
        return this.compressionMinRatio;
    }

    public boolean isCompressionEnabled() {
        return this.compressionEnabled;
    }

    public RetryStrategy getRetryStrategy() {
        return this.retryStrategy;
    }

    public Transcoder getTranscoder() {
        return this.transcoder;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isMutationTokensEnabled() {
        return this.mutationTokensEnabled;
    }

    public Long getConnectTimeout() {
        return this.connectTimeout;
    }

    public Long getKvTimeout() {
        return this.kvTimeout;
    }

    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    public long getAnalyticsTimeout() {
        return this.analyticsTimeout;
    }

    public long getDisconnectTimeout() {
        return this.disconnectTimeout;
    }

    public long getViewTimeout() {
        return this.viewTimeout;
    }

    public long getSearchTimeout() {
        return this.searchTimeout;
    }

    public long getConfigPollInterval() {
        return this.configPollInterval;
    }

    public long getIdleHttpConnectionTimeout() {
        return this.idleHttpConnectionTimeout;
    }

    public long getTcpKeepAliveTime() {
        return this.tcpKeepAliveTime;
    }

    public boolean isEnableDnsSrv() {
        return this.enableDnsSrv;
    }

    public NetworkResolution getNetworkResolution() {
        return this.networkResolution;
    }

    public String getTrustCertificate() {
        return this.trustCertificate;
    }

    public Long getWaitUntilReady() {
        return this.waitUntilReady;
    }

    public boolean isEnableTcpKeepAlives() {
        return this.enableTcpKeepAlives;
    }

    public ClusterEnvironment getEnv() {
        ClusterEnvironment.Builder builder = (ClusterEnvironment.Builder)ClusterEnvironment.builder().retryStrategy(this.retryStrategy);
        if (this.trustCertificate != null) {
            builder.securityConfig(SecurityConfig.builder().enableTls(true).trustCertificate(Path.of(this.trustCertificate, new String[0])));
        }
        if (this.compressionEnabled) {
            CompressionConfig.Builder compressionConfig = CompressionConfig.enable((boolean)true);
            compressionConfig.minSize(this.compressionMinSize.intValue());
            compressionConfig.minRatio(this.compressionMinRatio.doubleValue());
            builder.compressionConfig(compressionConfig);
        }
        if (this.transcoder != null) {
            builder.transcoder(this.transcoder);
        }
        builder.ioConfig(IoConfig.enableMutationTokens((boolean)this.mutationTokensEnabled).configPollInterval(Duration.ofMillis(this.configPollInterval)).idleHttpConnectionTimeout(Duration.ofMillis(this.idleHttpConnectionTimeout)).enableTcpKeepAlives(this.enableTcpKeepAlives).tcpKeepAliveTime(Duration.ofMillis(this.tcpKeepAliveTime)).enableDnsSrv(this.enableDnsSrv).networkResolution(this.networkResolution));
        long connectTimeoutFromConf = this.connectTimeout != null ? this.connectTimeout : Long.parseLong(this.getConfig("connectTimeout"));
        long kvTimeoutFromConf = this.kvTimeout != null ? this.kvTimeout : Long.parseLong(this.getConfig("kvTimeout"));
        builder.timeoutConfig(TimeoutConfig.connectTimeout((Duration)Duration.ofMillis(connectTimeoutFromConf)).kvTimeout(Duration.ofMillis(kvTimeoutFromConf)).queryTimeout(Duration.ofMillis(this.queryTimeout)).analyticsTimeout(Duration.ofMillis(this.analyticsTimeout)).disconnectTimeout(Duration.ofMillis(this.disconnectTimeout)).viewTimeout(Duration.ofMillis(this.viewTimeout)).searchTimeout(Duration.ofMillis(this.searchTimeout)));
        builder.ioEnvironment(IoEnvironment.builder().eventLoopThreadCount(Integer.parseInt(this.getConfig("ioPoolSize"))));
        return builder.build();
    }

    private String getConfig(String key) {
        return ApocConfig.apocConfig().getString("apoc.couchbase." + key, DEFAULT_CONFIG.get(key).toString());
    }

    static enum TrancoderConfig {
        DEFAULT(null),
        RAWJSON((Transcoder)RawJsonTranscoder.INSTANCE),
        RAWSTRING((Transcoder)RawStringTranscoder.INSTANCE),
        RAWBINARY((Transcoder)RawBinaryTranscoder.INSTANCE);

        private final Transcoder instance;

        private TrancoderConfig(Transcoder instance) {
            this.instance = instance;
        }

        Transcoder getInstance() {
            return this.instance;
        }
    }

    static enum RetryConfig {
        FAILFAST((RetryStrategy)FailFastRetryStrategy.INSTANCE),
        BESTEFFORT((RetryStrategy)BestEffortRetryStrategy.INSTANCE);

        private final RetryStrategy instance;

        private RetryConfig(RetryStrategy instance) {
            this.instance = instance;
        }

        RetryStrategy getInstance() {
            return this.instance;
        }
    }
}

