/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.load.LoadHtmlConfig;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class LoadHtmlBrowser {
    public static InputStream getChromeInputStream(String url, Map<String, String> query, LoadHtmlConfig config, boolean isHeadless, boolean isAcceptInsecureCerts) {
        WebDriverManager.chromedriver().setup();
        ChromeOptions chromeOptions = new ChromeOptions();
        chromeOptions.setHeadless(isHeadless);
        chromeOptions.setAcceptInsecureCerts(isAcceptInsecureCerts);
        return LoadHtmlBrowser.getInputStreamWithBrowser(url, query, config, (WebDriver)new ChromeDriver(chromeOptions));
    }

    public static InputStream getFirefoxInputStream(String url, Map<String, String> query, LoadHtmlConfig config, boolean isHeadless, boolean isAcceptInsecureCerts) {
        WebDriverManager.firefoxdriver().setup();
        FirefoxOptions firefoxOptions = new FirefoxOptions();
        firefoxOptions.setHeadless(isHeadless);
        firefoxOptions.setAcceptInsecureCerts(isAcceptInsecureCerts);
        return LoadHtmlBrowser.getInputStreamWithBrowser(url, query, config, (WebDriver)new FirefoxDriver(firefoxOptions));
    }

    private static InputStream getInputStreamWithBrowser(String url, Map<String, String> query, LoadHtmlConfig config, WebDriver driver) {
        driver.get(url);
        long wait = config.getWait();
        if (wait > 0L) {
            WebDriverWait driverWait = new WebDriverWait(driver, wait);
            try {
                driverWait.until(webDriver -> query.values().stream().noneMatch(selector -> webDriver.findElements(By.cssSelector((String)selector)).isEmpty()));
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
        InputStream stream = IOUtils.toInputStream((String)driver.getPageSource(), (String)config.getCharset());
        driver.close();
        return stream;
    }
}

