/*
 * Decompiled with CFR 0.152.
 */
package apoc.nlp.gcp;

import apoc.Extended;
import apoc.nlp.NLPHelperFunctions;
import apoc.nlp.gcp.DummyGCPClient;
import apoc.nlp.gcp.GCPClient;
import apoc.nlp.gcp.GCPProcedures;
import apoc.nlp.gcp.GCPVirtualClassificationGraph;
import apoc.nlp.gcp.GCPVirtualEntitiesGraph;
import apoc.nlp.gcp.RealGCPClient;
import apoc.result.NodeValueErrorMapResult;
import apoc.result.VirtualGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@Extended
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u00012\u0014\b\u0001\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0007J.\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\b\b\u0001\u0010\n\u001a\u00020\u00012\u0014\b\u0001\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0007J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0001\u0010\n\u001a\u00020\u00012\u0014\b\u0001\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0007J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\b\b\u0001\u0010\n\u001a\u00020\u00012\u0014\b\u0001\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\fH\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lapoc/nlp/gcp/GCPProcedures;", "", "()V", "log", "Lorg/neo4j/logging/Log;", "tx", "Lorg/neo4j/graphdb/Transaction;", "classifyGraph", "Ljava/util/stream/Stream;", "Lapoc/result/VirtualGraph;", "source", "config", "", "", "classifyStream", "Lapoc/result/NodeValueErrorMapResult;", "entitiesGraph", "entitiesStream", "gcpClient", "Lapoc/nlp/gcp/GCPClient;", "apoc"})
public final class GCPProcedures {
    @Context
    @JvmField
    @Nullable
    public Log log;
    @Context
    @JvmField
    @Nullable
    public Transaction tx;

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.gcp.entities.stream", mode=Mode.READ)
    @Description(value="Returns a stream of entities for provided text")
    @NotNull
    public final Stream<NodeValueErrorMapResult> entitiesStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        GCPClient client = this.gcpClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair = new Pair((Object)batch, client.entities((List<? extends Node>)batch, (int)index));
            collection.add(pair);
        }
        Stream<NodeValueErrorMapResult> stream = ((List)destination$iv$iv).stream().flatMap(entitiesStream.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"batches.mapIndexed { ind\u2026ult.map { it }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.gcp.entities.graph", mode=Mode.WRITE)
    @Description(value="Creates a (virtual) entity graph for provided text")
    @NotNull
    public final Stream<VirtualGraph> entitiesGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        GCPVirtualEntitiesGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        Iterable $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        GCPClient client = this.gcpClient(config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.entityRelationshipType(config);
        Object object2 = config.getOrDefault("writeRelationshipProperty", "score");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String relationshipProperty = (String)object2;
        Object object3 = config.getOrDefault("write", (Object)false);
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean storeGraph = (Boolean)object3;
        Object object4 = config.getOrDefault("scoreCutoff", (Object)0.0);
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
        }
        Number scoreCutoff = (Number)object4;
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable $this$mapIndexed$iv = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object = new Pair((Object)batch, client.entities((List<? extends Node>)batch, (int)index));
            collection.add(object);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void batch;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            List list = (List)$dstr$batch$result.component1();
            List result = (List)$dstr$batch$result.component2();
            object = new GCPVirtualEntitiesGraph(result, (List<? extends Node>)batch, relationshipType, relationshipProperty, scoreCutoff);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (GCPVirtualEntitiesGraph)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = storeGraph ? graph.createAndStore(this.tx) : graph.create();
            collection.add(object);
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"partition(convertedSourc\u2026                .stream()");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.gcp.classify.stream", mode=Mode.READ)
    @Description(value="Classifies a document into categories.")
    @NotNull
    public final Stream<NodeValueErrorMapResult> classifyStream(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        GCPClient client = this.gcpClient(config);
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        List<List<Node>> batches = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        Iterable $this$mapIndexed$iv = batches;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair = new Pair((Object)batch, client.classify((List<? extends Node>)batch, (int)index));
            collection.add(pair);
        }
        Stream<NodeValueErrorMapResult> stream = ((List)destination$iv$iv).stream().flatMap(classifyStream.2.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"batches.mapIndexed { ind\u2026ult.map { it }.stream() }");
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    @Procedure(value="apoc.nlp.gcp.classify.graph", mode=Mode.WRITE)
    @Description(value="Classifies a document into categories.")
    @NotNull
    public final Stream<VirtualGraph> classifyGraph(@Name(value="source") @NotNull Object source, @Name(value="config", defaultValue="{}") @NotNull Map<String, ? extends Object> config) {
        GCPVirtualClassificationGraph $dstr$batch$result;
        Iterable $this$mapTo$iv$iv;
        Object object;
        Collection collection;
        Iterable $this$mapIndexedTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull(config, (String)"config");
        NLPHelperFunctions.INSTANCE.verifySource(source);
        String nodeProperty = NLPHelperFunctions.INSTANCE.getNodeProperty(config);
        NLPHelperFunctions.INSTANCE.verifyNodeProperty(source, nodeProperty);
        NLPHelperFunctions.INSTANCE.verifyKey(config, "key");
        GCPClient client = this.gcpClient(config);
        RelationshipType relationshipType = NLPHelperFunctions.INSTANCE.categoryRelationshipType(config);
        Object object2 = config.getOrDefault("writeRelationshipProperty", "score");
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
        }
        String relationshipProperty = (String)object2;
        Object object3 = config.getOrDefault("write", (Object)false);
        if (object3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean storeGraph = (Boolean)object3;
        Object object4 = config.getOrDefault("scoreCutoff", (Object)0.0);
        if (object4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Number");
        }
        Number scoreCutoff = (Number)object4;
        List<Node> convertedSource = NLPHelperFunctions.INSTANCE.convert(source);
        Iterable $this$mapIndexed$iv = NLPHelperFunctions.INSTANCE.partition(convertedSource, 25);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv) {
            void index;
            void batch;
            int n = index$iv$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv2;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            object = new Pair((Object)batch, client.classify((List<? extends Node>)batch, (int)index));
            collection.add(object);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapIndexedTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void batch;
            Object item$iv$iv2;
            item$iv$iv2 = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            List list = (List)$dstr$batch$result.component1();
            List result = (List)$dstr$batch$result.component2();
            object = new GCPVirtualClassificationGraph(result, (List<? extends Node>)batch, relationshipType, relationshipProperty, scoreCutoff);
            collection.add(object);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void graph;
            $dstr$batch$result = (GCPVirtualClassificationGraph)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = storeGraph ? graph.createAndStore(this.tx) : graph.create();
            collection.add(object);
        }
        Stream<VirtualGraph> stream = ((List)destination$iv$iv).stream();
        Intrinsics.checkExpressionValueIsNotNull(stream, (String)"partition(convertedSourc\u2026                .stream()");
        return stream;
    }

    private final GCPClient gcpClient(Map<String, ? extends Object> config) {
        GCPClient gCPClient;
        Object object = config.getOrDefault("unsupportedDummyClient", (Object)false);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean useDummyClient = (Boolean)object;
        if (useDummyClient) {
            Log log = this.log;
            if (log == null) {
                Intrinsics.throwNpe();
            }
            gCPClient = new DummyGCPClient(config, log);
        } else {
            Log log = this.log;
            if (log == null) {
                Intrinsics.throwNpe();
            }
            gCPClient = new RealGCPClient(config, log);
        }
        return gCPClient;
    }
}

