/*
 * Decompiled with CFR 0.152.
 */
package apoc.mongodb;

import apoc.mongodb.MongoDB;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

class MongoDBColl
implements MongoDB.Coll {
    private static final ObjectMapper jsonMapper = new ObjectMapper().enable(DeserializationFeature.USE_LONG_FOR_INTS);
    public static final String ID = "_id";
    private final MongoCollection<Document> collection;
    private final MongoClient mongoClient;
    private boolean compatibleValues = false;
    private boolean doorStop = false;
    private final MongoDatabase database;
    private boolean extractReferences = false;
    private boolean objectIdAsMap = true;

    public MongoDBColl(String url, String db, String coll) {
        MongoClientURI connectionString = new MongoClientURI(url);
        this.mongoClient = new MongoClient(connectionString);
        this.database = this.mongoClient.getDatabase(db);
        this.collection = this.database.getCollection(coll);
    }

    public MongoDBColl(String url, String db, String coll, boolean compatibleValues, boolean extractReferences, boolean objectIdAsMap) {
        this(url, db, coll);
        this.compatibleValues = compatibleValues;
        this.extractReferences = extractReferences;
        this.objectIdAsMap = objectIdAsMap;
    }

    @Override
    public void close() throws IOException {
        if (this.doorStop) {
            return;
        }
        this.mongoClient.close();
    }

    private Map<String, Object> documentToPackableMap(Map<String, Object> document) {
        return (Map)this.convertAndExtract(document);
    }

    public Object convertAndExtract(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof Map) {
            Map map = (Map)data;
            return map.entrySet().stream().map(e -> {
                Object value;
                if (ID.equals(e.getKey())) {
                    if (this.compatibleValues && this.objectIdAsMap) {
                        try {
                            value = jsonMapper.readValue(jsonMapper.writeValueAsBytes(e.getValue()), Map.class);
                        }
                        catch (Exception exc) {
                            throw new RuntimeException("Cannot convert document to json and back to Map " + exc.getMessage());
                        }
                    } else {
                        value = e.getValue().toString();
                    }
                } else {
                    value = this.convertAndExtract(e.getValue());
                }
                return new AbstractMap.SimpleEntry(e.getKey(), value);
            }).collect(HashMap::new, (m, e) -> m.put(e.getKey(), e.getValue()), HashMap::putAll);
        }
        if (data instanceof Collection) {
            Collection collection = (Collection)data;
            return collection.stream().map(elem -> this.convertAndExtract(elem)).collect(Collectors.toList());
        }
        if (data.getClass().isArray() && !data.getClass().getComponentType().isPrimitive() && data.getClass().getComponentType().equals(String.class)) {
            return Stream.of((Object[])data).map(elem -> this.convertAndExtract(elem)).collect(Collectors.toList());
        }
        if (this.compatibleValues) {
            if (data instanceof Integer) {
                return ((Integer)data).longValue();
            }
            if (data instanceof Float) {
                return ((Float)data).doubleValue();
            }
            if (data instanceof Binary) {
                return ((Binary)data).getData();
            }
        }
        if (data instanceof Date) {
            return LocalDateTime.ofInstant(((Date)data).toInstant(), ZoneId.systemDefault());
        }
        if (data instanceof ObjectId) {
            return this.extractReferences ? this.extractReference((ObjectId)data) : data.toString();
        }
        return data;
    }

    private Object extractReference(ObjectId objectId) {
        return StreamSupport.stream(this.database.listCollectionNames().spliterator(), false).map(collectionName -> this.database.getCollection(collectionName)).map(collection -> (Document)collection.find((Bson)new Document(ID, (Object)objectId)).first()).filter(result -> result != null && !result.isEmpty()).findFirst().map(this::documentToPackableMap).orElse(null);
    }

    @Override
    public Map<String, Object> first(Map<String, Object> query) {
        return this.documentToPackableMap((Map)this.collection.find((Bson)new Document(query)).first());
    }

    @Override
    public Stream<Map<String, Object>> all(Map<String, Object> query, Long skip, Long limit) {
        FindIterable documents;
        FindIterable findIterable = documents = query == null ? this.collection.find() : this.collection.find((Bson)new Document(query));
        if (skip != 0L) {
            documents = documents.skip(skip.intValue());
        }
        if (limit != 0L) {
            documents = documents.limit(limit.intValue());
        }
        return this.asStream((FindIterable<Document>)documents);
    }

    @Override
    public long count(Map<String, Object> query) {
        return query == null ? this.collection.count() : this.collection.count((Bson)new Document(query));
    }

    private Stream<Map<String, Object>> asStream(FindIterable<Document> result) {
        this.doorStop = true;
        Iterable it = () -> result.iterator();
        return (Stream)StreamSupport.stream(it.spliterator(), false).map(doc -> this.documentToPackableMap((Map<String, Object>)doc)).onClose(() -> {
            result.iterator().close();
            this.mongoClient.close();
        });
    }

    @Override
    public Stream<Map<String, Object>> find(Map<String, Object> query, Map<String, Object> project, Map<String, Object> sort, Long skip, Long limit) {
        FindIterable documents;
        FindIterable findIterable = documents = query == null ? this.collection.find() : this.collection.find((Bson)new Document(query));
        if (project != null) {
            documents = documents.projection((Bson)new Document(project));
        }
        if (sort != null) {
            documents = documents.sort((Bson)new Document(sort));
        }
        if (skip != 0L) {
            documents = documents.skip(skip.intValue());
        }
        if (limit != 0L) {
            documents = documents.limit(limit.intValue());
        }
        return this.asStream((FindIterable<Document>)documents);
    }

    @Override
    public void insert(List<Map<String, Object>> docs) {
        for (Map<String, Object> doc : docs) {
            this.collection.insertOne((Object)new Document(doc));
        }
    }

    @Override
    public long update(Map<String, Object> query, Map<String, Object> update) {
        UpdateResult updateResult = this.collection.updateMany((Bson)new Document(query), (Bson)new Document(update));
        return updateResult.wasAcknowledged() ? updateResult.getModifiedCount() : -updateResult.getModifiedCount();
    }

    @Override
    public long delete(Map<String, Object> query) {
        DeleteResult result = this.collection.deleteMany((Bson)new Document(query));
        return result.wasAcknowledged() ? result.getDeletedCount() : -result.getDeletedCount();
    }
}

