/*
 * Decompiled with CFR 0.152.
 */
package apoc.uuid;

import apoc.ApocConfig;
import apoc.SystemLabels;
import apoc.SystemPropertyKeys;
import apoc.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;

public class UuidHandler
extends LifecycleAdapter
implements TransactionEventListener<Void> {
    private final GraphDatabaseAPI db;
    private final Log log;
    private final DatabaseManagementService databaseManagementService;
    private final ApocConfig apocConfig;
    private final ConcurrentHashMap<String, String> configuredLabelAndPropertyNames = new ConcurrentHashMap();
    private static final String NOT_ENABLED_ERROR = "UUID have not been enabled. Set 'apoc.uuid.enabled=true' in your apoc.conf file located in the $NEO4J_HOME/conf/ directory.";

    public UuidHandler(GraphDatabaseAPI db, DatabaseManagementService databaseManagementService, Log log, ApocConfig apocConfig, GlobalProceduresRegistry globalProceduresRegistry) {
        this.db = db;
        this.databaseManagementService = databaseManagementService;
        this.log = log;
        this.apocConfig = apocConfig;
    }

    public void start() {
        if (this.isEnabled()) {
            this.refresh();
            this.databaseManagementService.registerTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
        }
    }

    private boolean isEnabled() {
        return this.apocConfig.getBoolean("apoc.uuid.enabled");
    }

    public void stop() {
        if (this.isEnabled()) {
            this.databaseManagementService.unregisterTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
        }
    }

    private void checkAndRestoreUuidProperty(Iterable<PropertyEntry<Node>> nodeProperties, String label, String uuidProperty) {
        this.checkAndRestoreUuidProperty(nodeProperties, label, uuidProperty, null);
    }

    private void checkAndRestoreUuidProperty(Iterable<PropertyEntry<Node>> nodeProperties, String label, String uuidProperty, Predicate<PropertyEntry<Node>> predicate) {
        if (nodeProperties.iterator().hasNext()) {
            nodeProperties.forEach(nodePropertyEntry -> {
                if (predicate == null) {
                    if (((Node)nodePropertyEntry.entity()).hasLabel(Label.label((String)label)) && nodePropertyEntry.key().equals(uuidProperty)) {
                        ((Node)nodePropertyEntry.entity()).setProperty(uuidProperty, nodePropertyEntry.previouslyCommittedValue());
                    }
                } else if (((Node)nodePropertyEntry.entity()).hasLabel(Label.label((String)label)) && nodePropertyEntry.key().equals(uuidProperty) && predicate.test((PropertyEntry<Node>)nodePropertyEntry)) {
                    ((Node)nodePropertyEntry.entity()).setProperty(uuidProperty, nodePropertyEntry.previouslyCommittedValue());
                }
            });
        }
    }

    public Void beforeCommit(TransactionData txData, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
        Iterable createdNodes = txData.createdNodes();
        Iterable assignedNodeProperties = txData.assignedNodeProperties();
        Iterable removedNodeProperties = txData.removedNodeProperties();
        this.configuredLabelAndPropertyNames.forEach((label, propertyName) -> {
            try {
                if (createdNodes.iterator().hasNext()) {
                    createdNodes.forEach(node -> {
                        if (node.hasLabel(Label.label((String)label)) && !node.hasProperty(propertyName)) {
                            String uuid = UUID.randomUUID().toString();
                            node.setProperty(propertyName, (Object)uuid);
                        }
                    });
                }
                this.checkAndRestoreUuidProperty(assignedNodeProperties, (String)label, (String)propertyName, nodePropertyEntry -> nodePropertyEntry.value() == null || nodePropertyEntry.value().equals(""));
                this.checkAndRestoreUuidProperty(removedNodeProperties, (String)label, (String)propertyName);
            }
            catch (Exception e) {
                this.log.warn("Error executing uuid " + label + " in phase before", (Throwable)e);
            }
        });
        return null;
    }

    public void afterCommit(TransactionData data, Void state, GraphDatabaseService databaseService) {
    }

    public void afterRollback(TransactionData data, Void state, GraphDatabaseService databaseService) {
    }

    private void checkEnabled() {
        if (!this.isEnabled()) {
            throw new RuntimeException(NOT_ENABLED_ERROR);
        }
    }

    public void checkConstraintUuid(Transaction tx, String label, String propertyName) {
        Schema schema = tx.schema();
        Stream<ConstraintDefinition> constraintDefinitionStream = StreamSupport.stream(schema.getConstraints(Label.label((String)label)).spliterator(), false);
        boolean exists = constraintDefinitionStream.anyMatch(constraint -> {
            Stream<String> streamPropertyKeys = StreamSupport.stream(constraint.getPropertyKeys().spliterator(), false);
            return streamPropertyKeys.anyMatch(property -> property.equals(propertyName));
        });
        if (!exists) {
            String error = String.format("`CREATE CONSTRAINT ON (%s:%s) ASSERT %s.%s IS UNIQUE`", label.toLowerCase(), label, label.toLowerCase(), propertyName);
            throw new RuntimeException("No constraint found for label: " + label + ", please add the constraint with the following : " + error);
        }
    }

    public void add(Transaction tx, String label, String propertyName) {
        this.checkEnabled();
        this.checkConstraintUuid(tx, label, propertyName);
        this.configuredLabelAndPropertyNames.put(label, propertyName);
        try (Transaction sysTx = this.apocConfig.getSystemDb().beginTx();){
            Node node = Util.mergeNode(sysTx, SystemLabels.ApocUuid, null, Pair.of((Object)SystemPropertyKeys.database.name(), (Object)this.db.databaseName()), Pair.of((Object)SystemPropertyKeys.label.name(), (Object)label), Pair.of((Object)SystemPropertyKeys.propertyName.name(), (Object)propertyName));
            sysTx.commit();
        }
    }

    public Map<String, String> list() {
        this.checkEnabled();
        return this.configuredLabelAndPropertyNames;
    }

    public void refresh() {
        this.configuredLabelAndPropertyNames.clear();
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)SystemLabels.ApocUuid, SystemPropertyKeys.database.name(), (Object)this.db.databaseName()).forEachRemaining(node -> this.configuredLabelAndPropertyNames.put((String)node.getProperty(SystemPropertyKeys.label.name()), (String)node.getProperty(SystemPropertyKeys.propertyName.name())));
            tx.commit();
        }
    }

    public synchronized String remove(String label) {
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)SystemLabels.ApocUuid, SystemPropertyKeys.database.name(), (Object)this.db.databaseName(), SystemPropertyKeys.label.name(), (Object)label).forEachRemaining(node -> node.delete());
            tx.commit();
        }
        return this.configuredLabelAndPropertyNames.remove(label);
    }

    public synchronized Map<String, String> removeAll() {
        HashMap<String, String> retval = new HashMap<String, String>(this.configuredLabelAndPropertyNames);
        this.configuredLabelAndPropertyNames.clear();
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)SystemLabels.ApocUuid, SystemPropertyKeys.database.name(), (Object)this.db.databaseName()).forEachRemaining(node -> node.delete());
            tx.commit();
        }
        return retval;
    }
}

