/*
 * Decompiled with CFR 0.152.
 */
package apoc.util.s3;

import apoc.util.StreamConnection;
import apoc.util.s3.S3Params;
import apoc.util.s3.S3URLConnection;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import java.io.IOException;
import java.io.InputStream;

public class S3Aws {
    AmazonS3 s3Client;

    public S3Aws(S3Params s3Params, String region) {
        this.s3Client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(s3Params.getAccessKey(), s3Params.getSecretKey())))).withClientConfiguration(S3URLConnection.buildClientConfig())).withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(s3Params.getEndpoint(), region))).build();
    }

    public StreamConnection getS3AwsInputStream(S3Params s3Params) {
        final S3Object s3Object = this.s3Client.getObject(s3Params.getBucket(), s3Params.getKey());
        final ObjectMetadata metadata = s3Object.getObjectMetadata();
        return new StreamConnection(){

            @Override
            public InputStream getInputStream() throws IOException {
                return s3Object.getObjectContent();
            }

            @Override
            public String getEncoding() {
                return metadata.getContentEncoding();
            }

            @Override
            public long getLength() {
                return metadata.getContentLength();
            }
        };
    }
}

