/*
 * Decompiled with CFR 0.152.
 */
package apoc.util;

import java.io.StringWriter;
import java.util.Arrays;

public class FixedSizeStringWriter
extends StringWriter {
    public static final int MAX_SIZE = 1000;
    private final int fixedSize;
    private boolean exceeded = false;

    public FixedSizeStringWriter() {
        this(1000);
    }

    public FixedSizeStringWriter(int maxSize) {
        super(maxSize);
        this.fixedSize = maxSize;
    }

    @Override
    public void write(int c) {
        throw new UnsupportedOperationException("Method unsupported");
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (this.exceedFixedSize(cbuf = Arrays.copyOfRange(cbuf, off, Math.min(off + len, cbuf.length)))) {
            cbuf = Arrays.copyOf(cbuf, this.fixedSize - this.getBuffer().length());
        }
        super.write(cbuf, 0, cbuf.length);
    }

    private boolean exceedFixedSize(char[] cbuf) {
        this.exceeded = this.getBuffer().length() + cbuf.length > this.fixedSize;
        return this.exceeded;
    }

    @Override
    public void write(String str) {
        this.write(str.toCharArray(), 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) {
        this.write(str.toCharArray(), off, len);
    }

    public boolean isExceeded() {
        return this.exceeded;
    }
}

