/*
 * Decompiled with CFR 0.152.
 */
package apoc.trigger;

import apoc.ApocConfig;
import apoc.SystemLabels;
import apoc.SystemPropertyKeys;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.event.LabelEntry;
import org.neo4j.graphdb.event.PropertyEntry;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.procedure.impl.GlobalProceduresRegistry;

public class TriggerHandler
extends LifecycleAdapter
implements TransactionEventListener<Void> {
    private final ConcurrentHashMap<String, Map<String, Object>> activeTriggers = new ConcurrentHashMap();
    private final Log log;
    private final GraphDatabaseService db;
    private final DatabaseManagementService databaseManagementService;
    private final ApocConfig apocConfig;
    public static final String NOT_ENABLED_ERROR = "Triggers have not been enabled. Set 'apoc.trigger.enabled=true' in your apoc.conf file located in the $NEO4J_HOME/conf/ directory.";
    private final ThrowingFunction<Context, Transaction, ProcedureException> transactionComponentFunction;

    public TriggerHandler(GraphDatabaseService db, DatabaseManagementService databaseManagementService, ApocConfig apocConfig, Log log, GlobalProceduresRegistry globalProceduresRegistry) {
        this.db = db;
        this.databaseManagementService = databaseManagementService;
        this.apocConfig = apocConfig;
        this.log = log;
        this.transactionComponentFunction = globalProceduresRegistry.lookupComponentProvider(Transaction.class, true);
    }

    private boolean isEnabled() {
        return this.apocConfig.getBoolean("apoc.trigger.enabled");
    }

    public void checkEnabled() {
        if (!this.isEnabled()) {
            throw new RuntimeException(NOT_ENABLED_ERROR);
        }
    }

    private void updateCache() {
        this.activeTriggers.clear();
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)SystemLabels.ApocTrigger, SystemPropertyKeys.database.name(), (Object)this.db.databaseName()).forEachRemaining(node -> this.activeTriggers.put((String)node.getProperty(SystemPropertyKeys.name.name()), MapUtil.map((Object[])new Object[]{"statement", node.getProperty(SystemPropertyKeys.statement.name()), "selector", Util.fromJson((String)node.getProperty(SystemPropertyKeys.selector.name()), Map.class), "params", Util.fromJson((String)node.getProperty(SystemPropertyKeys.params.name()), Map.class), "paused", node.getProperty(SystemPropertyKeys.paused.name())})));
            tx.commit();
        }
    }

    public Map<String, Object> add(String name, String statement, Map<String, Object> selector) {
        return this.add(name, statement, selector, Collections.emptyMap());
    }

    public Map<String, Object> add(String name, String statement, Map<String, Object> selector, Map<String, Object> params) {
        this.checkEnabled();
        Map<String, Object> previous = this.activeTriggers.get(name);
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            Node node = Util.mergeNode(tx, SystemLabels.ApocTrigger, null, Pair.of((Object)SystemPropertyKeys.database.name(), (Object)this.db.databaseName()), Pair.of((Object)SystemPropertyKeys.name.name(), (Object)name));
            node.setProperty(SystemPropertyKeys.statement.name(), (Object)statement);
            node.setProperty(SystemPropertyKeys.selector.name(), (Object)Util.toJson(selector));
            node.setProperty(SystemPropertyKeys.params.name(), (Object)Util.toJson(params));
            node.setProperty(SystemPropertyKeys.paused.name(), (Object)false);
            tx.commit();
        }
        this.updateCache();
        return previous;
    }

    public Map<String, Object> remove(String name) {
        this.checkEnabled();
        Map<String, Object> previous = this.activeTriggers.remove(name);
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)SystemLabels.ApocTrigger, SystemPropertyKeys.database.name(), (Object)this.db.databaseName(), SystemPropertyKeys.name.name(), (Object)name).forEachRemaining(node -> node.delete());
            tx.commit();
        }
        this.updateCache();
        return previous;
    }

    public Map<String, Object> updatePaused(String name, boolean paused) {
        this.checkEnabled();
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)SystemLabels.ApocTrigger, SystemPropertyKeys.database.name(), (Object)this.db.databaseName(), SystemPropertyKeys.name.name(), (Object)name).forEachRemaining(node -> node.setProperty(SystemPropertyKeys.paused.name(), (Object)paused));
            tx.commit();
        }
        this.updateCache();
        return this.activeTriggers.get(name);
    }

    public Map<String, Object> removeAll() {
        this.checkEnabled();
        Map<String, Object> previous = this.activeTriggers.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
        try (Transaction tx = this.apocConfig.getSystemDb().beginTx();){
            tx.findNodes((Label)SystemLabels.ApocTrigger, SystemPropertyKeys.database.name(), (Object)this.db.databaseName()).forEachRemaining(node -> node.delete());
            tx.commit();
        }
        this.updateCache();
        return previous;
    }

    public Map<String, Map<String, Object>> list() {
        this.checkEnabled();
        return this.activeTriggers;
    }

    public Void beforeCommit(TransactionData txData, Transaction transaction, GraphDatabaseService databaseService) {
        this.executeTriggers(transaction, txData, "before");
        return null;
    }

    public void afterCommit(TransactionData txData, Void state, GraphDatabaseService databaseService) {
        try (Transaction tx = this.db.beginTx();){
            this.executeTriggers(tx, txData, "after");
            tx.commit();
        }
    }

    public void afterRollback(TransactionData txData, Void state, GraphDatabaseService databaseService) {
        try (Transaction tx = this.db.beginTx();){
            this.executeTriggers(tx, txData, "rollback");
            tx.commit();
        }
    }

    static <T extends Entity> Map<String, List<Map<String, Object>>> aggregatePropertyKeys(Iterable<PropertyEntry<T>> entries, boolean nodes, boolean removed) {
        if (!entries.iterator().hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        String entityType = nodes ? "node" : "relationship";
        for (PropertyEntry entry : entries) {
            result.compute(entry.key(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Map<String, Object>>(100);
                }
                Map<String, Object> map = Util.map("key", k, entityType, entry.entity(), "old", entry.previouslyCommittedValue());
                if (!removed) {
                    map.put("new", entry.value());
                }
                v.add(map);
                return v;
            });
        }
        return result;
    }

    private Map<String, List<Node>> aggregateLabels(Iterable<LabelEntry> labelEntries) {
        if (!labelEntries.iterator().hasNext()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Node>> result = new HashMap<String, List<Node>>();
        for (LabelEntry entry : labelEntries) {
            result.compute(entry.label().name(), (k, v) -> {
                if (v == null) {
                    v = new ArrayList<Node>(100);
                }
                v.add(entry.node());
                return v;
            });
        }
        return result;
    }

    private Map<String, Object> txDataParams(TransactionData txData, String phase) {
        return Util.map("transactionId", phase.equals("after") ? txData.getTransactionId() : -1L, "commitTime", phase.equals("after") ? txData.getCommitTime() : -1L, "createdNodes", txData.createdNodes(), "createdRelationships", txData.createdRelationships(), "deletedNodes", txData.deletedNodes(), "deletedRelationships", txData.deletedRelationships(), "removedLabels", this.aggregateLabels(txData.removedLabels()), "removedNodeProperties", TriggerHandler.aggregatePropertyKeys(txData.removedNodeProperties(), true, true), "removedRelationshipProperties", TriggerHandler.aggregatePropertyKeys(txData.removedRelationshipProperties(), false, true), "assignedLabels", this.aggregateLabels(txData.assignedLabels()), "assignedNodeProperties", TriggerHandler.aggregatePropertyKeys(txData.assignedNodeProperties(), true, false), "assignedRelationshipProperties", TriggerHandler.aggregatePropertyKeys(txData.assignedRelationshipProperties(), false, false));
    }

    private void executeTriggers(Transaction tx, TransactionData txData, String phase) {
        LinkedHashMap exceptions = new LinkedHashMap();
        Map<String, Object> params = this.txDataParams(txData, phase);
        this.activeTriggers.forEach((name, data) -> {
            if (data.get("params") != null) {
                params.putAll((Map)data.get("params"));
            }
            Map selector = (Map)data.get("selector");
            if (!((Boolean)data.get("paused")).booleanValue() && this.when(selector, phase)) {
                try {
                    params.put("trigger", name);
                    Result result = tx.execute((String)data.get("statement"), params);
                    Iterators.count((Iterator)result);
                }
                catch (Exception e) {
                    this.log.warn("Error executing trigger " + name + " in phase " + phase, (Throwable)e);
                    exceptions.put(name, e.getMessage());
                }
            }
        });
        if (!exceptions.isEmpty()) {
            throw new RuntimeException("Error executing triggers " + ((Object)exceptions).toString());
        }
    }

    private boolean when(Map<String, Object> selector, String phase) {
        if (selector == null) {
            return phase.equals("before");
        }
        return selector.getOrDefault("phase", "before").equals(phase);
    }

    public void start() {
        if (this.isEnabled()) {
            this.databaseManagementService.registerTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
        }
    }

    public void stop() {
        if (this.isEnabled()) {
            this.databaseManagementService.unregisterTransactionEventListener(this.db.databaseName(), (TransactionEventListener)this);
        }
    }
}

