/*
 * Decompiled with CFR 0.152.
 */
package apoc.result;

import apoc.result.VirtualRelationship;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.internal.helpers.collection.FilteringIterable;
import org.neo4j.internal.helpers.collection.Iterables;

public class WrappedNode
implements Node {
    private static AtomicLong MIN_ID = new AtomicLong(-1L);
    private final List<Label> labels = new ArrayList<Label>();
    private final Map<String, Object> props = new HashMap<String, Object>();
    private final List<Relationship> rels = new ArrayList<Relationship>();
    private final GraphDatabaseService db;
    private final long id;

    public WrappedNode(Label[] labels, Map<String, Object> props, GraphDatabaseService db) {
        this.id = MIN_ID.getAndDecrement();
        this.db = db;
        this.labels.addAll(Arrays.asList(labels));
        this.props.putAll(props);
    }

    public WrappedNode(long nodeId, GraphDatabaseService db) {
        this.id = nodeId;
        this.db = db;
    }

    public long getId() {
        return this.id;
    }

    public void delete() {
        for (Relationship rel : this.rels) {
            rel.delete();
        }
    }

    public Iterable<Relationship> getRelationships() {
        return this.rels;
    }

    public boolean hasRelationship() {
        return !this.rels.isEmpty();
    }

    public Iterable<Relationship> getRelationships(RelationshipType ... relationshipTypes) {
        return new FilteringIterable(this.rels, r -> this.isType((Relationship)r, relationshipTypes));
    }

    private boolean isType(Relationship r, RelationshipType ... relationshipTypes) {
        for (RelationshipType type : relationshipTypes) {
            if (!r.isType(type)) continue;
            return true;
        }
        return false;
    }

    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... relationshipTypes) {
        return new FilteringIterable(this.rels, r -> this.isType((Relationship)r, relationshipTypes) && this.isDirection((Relationship)r, direction));
    }

    private boolean isDirection(Relationship r, Direction direction) {
        return direction == Direction.BOTH || direction == Direction.OUTGOING && r.getStartNode().equals(this) || direction == Direction.INCOMING && r.getEndNode().equals(this);
    }

    public boolean hasRelationship(RelationshipType ... relationshipTypes) {
        return this.getRelationships(relationshipTypes).iterator().hasNext();
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... relationshipTypes) {
        return this.getRelationships(direction, relationshipTypes).iterator().hasNext();
    }

    public Iterable<Relationship> getRelationships(Direction direction) {
        return new FilteringIterable(this.rels, r -> this.isDirection((Relationship)r, direction));
    }

    public boolean hasRelationship(Direction direction) {
        return this.getRelationships(direction).iterator().hasNext();
    }

    public Relationship getSingleRelationship(RelationshipType relationshipType, Direction direction) {
        return null;
    }

    public Relationship createRelationshipTo(Node node, RelationshipType relationshipType) {
        VirtualRelationship rel = new VirtualRelationship(this, node, relationshipType);
        return null;
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        return null;
    }

    public int getDegree() {
        return this.rels.size();
    }

    public int getDegree(RelationshipType relationshipType) {
        return (int)Iterables.count(this.getRelationships(relationshipType));
    }

    public int getDegree(Direction direction) {
        return (int)Iterables.count(this.getRelationships(direction));
    }

    public int getDegree(RelationshipType relationshipType, Direction direction) {
        return (int)Iterables.count(this.getRelationships(direction, relationshipType));
    }

    public void addLabel(Label label) {
        this.labels.add(label);
    }

    public void removeLabel(Label label) {
        Iterator<Label> iterator = this.labels.iterator();
        while (iterator.hasNext()) {
            Label next = iterator.next();
            if (!next.name().equals(label.name())) continue;
            iterator.remove();
        }
    }

    public boolean hasLabel(Label label) {
        for (Label l : this.labels) {
            if (!l.name().equals(label.name())) continue;
            return true;
        }
        return false;
    }

    public Iterable<Label> getLabels() {
        return this.labels;
    }

    public boolean hasProperty(String s) {
        return this.props.containsKey(s);
    }

    public Object getProperty(String s) {
        return this.props.get(s);
    }

    public Object getProperty(String s, Object o) {
        Object value = this.props.get(s);
        return value == null ? o : value;
    }

    public void setProperty(String s, Object o) {
        this.props.put(s, o);
    }

    public Object removeProperty(String s) {
        return this.props.remove(s);
    }

    public Iterable<String> getPropertyKeys() {
        return this.props.keySet();
    }

    public Map<String, Object> getProperties(String ... strings) {
        HashMap<String, Object> res = new HashMap<String, Object>(this.props);
        res.entrySet().retainAll(Arrays.asList(strings));
        return res;
    }

    public Map<String, Object> getAllProperties() {
        return this.props;
    }

    void delete(Relationship rel) {
        this.rels.remove(rel);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Node && this.id == ((Node)o).getId();
    }

    public int hashCode() {
        return (int)(this.id ^ this.id >>> 32);
    }
}

