/*
 * Decompiled with CFR 0.152.
 */
package apoc.nodes;

import apoc.Pools;
import apoc.create.Create;
import apoc.path.RelationshipTypeAndDirections;
import apoc.refactor.util.PropertiesManager;
import apoc.refactor.util.RefactorConfig;
import apoc.refactor.util.RefactorUtil;
import apoc.result.LongResult;
import apoc.result.NodeResult;
import apoc.result.RelationshipResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualPathResult;
import apoc.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenRead;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Nodes {
    @Context
    public GraphDatabaseService db;
    @Context
    public Transaction tx;
    @Context
    public KernelTransaction ktx;
    @Context
    public Pools pools;

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.nodes.link([nodes],'REL_TYPE') - creates a linked list of nodes from first to last")
    public void link(@Name(value="nodes") List<Node> nodes, @Name(value="type") String type) {
        Iterator<Node> it = nodes.iterator();
        if (it.hasNext()) {
            RelationshipType relType = RelationshipType.withName((String)type);
            Node node = it.next();
            while (it.hasNext()) {
                Node next = it.next();
                node.createRelationshipTo(next, relType);
                node = next;
            }
        }
    }

    @Procedure
    @Description(value="apoc.nodes.get(node|nodes|id|[ids]) - quickly returns all nodes with these ids")
    public Stream<NodeResult> get(@Name(value="nodes") Object ids) {
        return Util.nodeStream(this.tx, ids).map(NodeResult::new);
    }

    @Procedure(mode=Mode.WRITE)
    @Description(value="apoc.nodes.delete(node|nodes|id|[ids]) - quickly delete all nodes with these ids")
    public Stream<LongResult> delete(@Name(value="nodes") Object ids, @Name(value="batchSize") long batchSize) {
        Iterator it = Util.nodeStream(this.tx, ids).iterator();
        long count = 0L;
        while (it.hasNext()) {
            List batch = Util.take(it, (int)batchSize);
            count += (long)Util.inTx(this.db, this.pools, txInThread -> {
                txInThread.execute("FOREACH (n in $nodes | DETACH DELETE n)", Util.map("nodes", batch)).close();
                return batch.size();
            }).intValue();
        }
        return Stream.of(new LongResult(count));
    }

    @Procedure
    @Description(value="apoc.get.rels(rel|id|[ids]) - quickly returns all relationships with these ids")
    public Stream<RelationshipResult> rels(@Name(value="relationships") Object ids) {
        return Util.relsStream(this.tx, ids).map(RelationshipResult::new);
    }

    @UserFunction(value="apoc.node.relationship.exists")
    @Description(value="apoc.node.relationship.exists(node, rel-direction-pattern) - returns true when the node has the relationships of the pattern")
    public boolean hasRelationship(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types) {
        if (types == null || types.isEmpty()) {
            return node.hasRelationship();
        }
        long id = node.getId();
        try (NodeCursor nodeCursor = this.ktx.cursors().allocateNodeCursor();){
            this.ktx.dataRead().singleNode(id, nodeCursor);
            nodeCursor.next();
            TokenRead tokenRead = this.ktx.tokenRead();
            for (Pair<RelationshipType, Direction> pair : RelationshipTypeAndDirections.parse(types)) {
                int count;
                int typeId = tokenRead.relationshipType(((RelationshipType)pair.first()).name());
                Direction direction = (Direction)pair.other();
                switch (direction) {
                    case INCOMING: {
                        count = org.neo4j.internal.kernel.api.helpers.Nodes.countIncoming((NodeCursor)nodeCursor, (CursorFactory)this.ktx.cursors(), (int)typeId);
                        break;
                    }
                    case OUTGOING: {
                        count = org.neo4j.internal.kernel.api.helpers.Nodes.countOutgoing((NodeCursor)nodeCursor, (CursorFactory)this.ktx.cursors(), (int)typeId);
                        break;
                    }
                    case BOTH: {
                        count = org.neo4j.internal.kernel.api.helpers.Nodes.countAll((NodeCursor)nodeCursor, (CursorFactory)this.ktx.cursors(), (int)typeId);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("invalid direction " + direction);
                    }
                }
                if (count <= 0) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @UserFunction(value="apoc.nodes.connected")
    @Description(value="apoc.nodes.connected(start, end, rel-direction-pattern) - returns true when the node is connected to the other node, optimized for dense nodes")
    public boolean connected(@Name(value="start") Node start, @Name(value="start") Node end, @Name(value="types", defaultValue="") String types) {
        if (start == null || end == null) {
            return false;
        }
        if (start.equals(end)) {
            return true;
        }
        long startId = start.getId();
        long endId = end.getId();
        List<Pair<RelationshipType, Direction>> pairs = types == null || types.isEmpty() ? null : RelationshipTypeAndDirections.parse(types);
        Read dataRead = this.ktx.dataRead();
        TokenRead tokenRead = this.ktx.tokenRead();
        CursorFactory cursors = this.ktx.cursors();
        try (NodeCursor startNodeCursor = cursors.allocateNodeCursor();){
            boolean bl;
            block24: {
                NodeCursor endNodeCursor;
                block22: {
                    boolean bl2;
                    block23: {
                        boolean endDense;
                        block20: {
                            boolean bl3;
                            block21: {
                                endNodeCursor = cursors.allocateNodeCursor();
                                try {
                                    dataRead.singleNode(startId, startNodeCursor);
                                    if (!startNodeCursor.next()) {
                                        throw new IllegalArgumentException("node with id " + startId + " does not exist.");
                                    }
                                    boolean startDense = startNodeCursor.isDense();
                                    dataRead.singleNode(endId, endNodeCursor);
                                    if (!endNodeCursor.next()) {
                                        throw new IllegalArgumentException("node with id " + endId + " does not exist.");
                                    }
                                    endDense = endNodeCursor.isDense();
                                    if (startDense) break block20;
                                    bl3 = this.connected(startNodeCursor, endId, this.typedDirections(tokenRead, pairs, true));
                                    if (endNodeCursor == null) break block21;
                                }
                                catch (Throwable throwable) {
                                    if (endNodeCursor != null) {
                                        try {
                                            endNodeCursor.close();
                                        }
                                        catch (Throwable throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                    }
                                    throw throwable;
                                }
                                endNodeCursor.close();
                            }
                            return bl3;
                        }
                        if (endDense) break block22;
                        bl2 = this.connected(endNodeCursor, startId, this.typedDirections(tokenRead, pairs, false));
                        if (endNodeCursor == null) break block23;
                        endNodeCursor.close();
                    }
                    return bl2;
                }
                bl = this.connectedDense(startNodeCursor, endNodeCursor, this.typedDirections(tokenRead, pairs, true));
                if (endNodeCursor == null) break block24;
                endNodeCursor.close();
            }
            return bl;
        }
    }

    @Procedure
    @Description(value="apoc.nodes.collapse([nodes...],[{properties:'overwrite' or 'discard' or 'combine'}]) yield from, rel, to merge nodes onto first in list")
    public Stream<VirtualPathResult> collapse(@Name(value="nodes") List<Node> nodes, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (nodes == null || nodes.isEmpty()) {
            return Stream.empty();
        }
        if (nodes.size() == 1) {
            return Stream.of(new VirtualPathResult(nodes.get(0), null, null));
        }
        LinkedHashSet<Node> nodeSet = new LinkedHashSet<Node>(nodes);
        RefactorConfig conf = new RefactorConfig(config);
        VirtualNode first = this.createVirtualNode(nodeSet, conf);
        if (first.getRelationships().iterator().hasNext()) {
            return StreamSupport.stream(first.getRelationships().spliterator(), false).map(relationship -> new VirtualPathResult(relationship.getStartNode(), (Relationship)relationship, relationship.getEndNode()));
        }
        return Stream.of(new VirtualPathResult(first, null, null));
    }

    private VirtualNode createVirtualNode(Set<Node> nodes, RefactorConfig conf) {
        Create create = new Create();
        Node first = nodes.iterator().next();
        List<String> labels = Util.labelStrings(first);
        if (conf.isCollapsedLabel()) {
            labels.add("Collapsed");
        }
        VirtualNode virtualNode = (VirtualNode)create.vNodeFunction(labels, first.getAllProperties());
        this.createVirtualRelationships(nodes, virtualNode, first, conf);
        nodes.stream().skip(1L).forEach(node -> {
            virtualNode.addLabels(node.getLabels());
            PropertiesManager.mergeProperties(node.getAllProperties(), (Entity)virtualNode, conf);
            this.createVirtualRelationships(nodes, virtualNode, (Node)node, conf);
        });
        if (conf.isCountMerge()) {
            virtualNode.setProperty("count", nodes.size());
        }
        return virtualNode;
    }

    private void createVirtualRelationships(Set<Node> nodes, VirtualNode virtualNode, Node node, RefactorConfig refactorConfig) {
        node.getRelationships().forEach(relationship -> {
            Node startNode = relationship.getStartNode();
            Node endNode = relationship.getEndNode();
            if (nodes.contains(startNode) && nodes.contains(endNode)) {
                if (refactorConfig.isSelfRel()) {
                    this.createOrMergeVirtualRelationship(virtualNode, refactorConfig, (Relationship)relationship, virtualNode, Direction.OUTGOING);
                }
            } else if (startNode.getId() == node.getId()) {
                this.createOrMergeVirtualRelationship(virtualNode, refactorConfig, (Relationship)relationship, endNode, Direction.OUTGOING);
            } else {
                this.createOrMergeVirtualRelationship(virtualNode, refactorConfig, (Relationship)relationship, startNode, Direction.INCOMING);
            }
        });
    }

    private void createOrMergeVirtualRelationship(VirtualNode virtualNode, RefactorConfig refactorConfig, Relationship source, Node node, Direction direction) {
        Iterable<Relationship> rels = virtualNode.getRelationships(direction, source.getType());
        Optional<Relationship> first = StreamSupport.stream(rels.spliterator(), false).filter(relationship -> relationship.getOtherNode((Node)virtualNode).equals(node)).findFirst();
        if (refactorConfig.isMergeVirtualRels() && first.isPresent()) {
            this.mergeRelationship(source, first.get(), refactorConfig);
        } else {
            if (direction == Direction.OUTGOING) {
                RefactorUtil.copyProperties((Entity)source, virtualNode.createRelationshipTo(node, source.getType()));
            }
            if (direction == Direction.INCOMING) {
                RefactorUtil.copyProperties((Entity)source, virtualNode.createRelationshipFrom(node, source.getType()));
            }
        }
    }

    private void mergeRelationship(Relationship source, Relationship target, RefactorConfig refactorConfig) {
        if (refactorConfig.isCountMerge()) {
            target.setProperty("count", (Object)((Integer)target.getProperty("count", (Object)0) + 1));
        }
        PropertiesManager.mergeProperties(source.getAllProperties(), (Entity)target, refactorConfig);
    }

    private boolean connected(NodeCursor start, long end, int[][] typedDirections) {
        try (RelationshipTraversalCursor relationship = this.ktx.cursors().allocateRelationshipTraversalCursor();){
            start.allRelationships(relationship);
            while (relationship.next()) {
                if (relationship.neighbourNodeReference() != end) continue;
                if (typedDirections == null) {
                    boolean bl = true;
                    return bl;
                }
                int direction = relationship.targetNodeReference() == end ? 0 : 1;
                int[] types = typedDirections[direction];
                if (!this.arrayContains(types, relationship.type())) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean arrayContains(int[] array, int element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return true;
        }
        return false;
    }

    private int[][] typedDirections(TokenRead ops, List<Pair<RelationshipType, Direction>> pairs, boolean outgoing) {
        if (pairs == null) {
            return null;
        }
        int from = 0;
        int to = 0;
        int[][] result = new int[2][pairs.size()];
        int outIdx = Direction.OUTGOING.ordinal();
        int inIdx = Direction.INCOMING.ordinal();
        for (Pair<RelationshipType, Direction> pair : pairs) {
            int type = ops.relationshipType(((RelationshipType)pair.first()).name());
            if (type == -1) continue;
            if (pair.other() != Direction.INCOMING) {
                result[outIdx][from++] = type;
            }
            if (pair.other() == Direction.OUTGOING) continue;
            result[inIdx][to++] = type;
        }
        result[outIdx] = Arrays.copyOf(result[outIdx], from);
        result[inIdx] = Arrays.copyOf(result[inIdx], to);
        if (!outgoing) {
            int[] tmp = result[outIdx];
            result[outIdx] = result[inIdx];
            result[inIdx] = tmp;
        }
        return result;
    }

    private boolean connectedDense(NodeCursor start, NodeCursor end, int[][] typedDirections) {
        ArrayList<Degree> degrees = new ArrayList<Degree>(32);
        Read read = this.ktx.dataRead();
        try (RelationshipGroupCursor relationshipGroup = this.ktx.cursors().allocateRelationshipGroupCursor();){
            this.addDegreesForNode(read, start, end, degrees, relationshipGroup, typedDirections);
            this.addDegreesForNode(read, end, start, degrees, relationshipGroup, typedDirections);
        }
        Collections.sort(degrees);
        try (RelationshipTraversalCursor relationship = this.ktx.cursors().allocateRelationshipTraversalCursor();){
            for (Degree degree : degrees) {
                if (!degree.isConnected(this.ktx.dataRead(), relationship)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private void addDegreesForNode(Read dataRead, NodeCursor node, NodeCursor other, List<Degree> degrees, RelationshipGroupCursor relationshipGroup, int[][] typedDirections) {
        long nodeId = node.nodeReference();
        long otherId = other.nodeReference();
        dataRead.relationshipGroups(nodeId, node.relationshipGroupReference(), relationshipGroup);
        while (relationshipGroup.next()) {
            int type = relationshipGroup.type();
            if (typedDirections == null || this.arrayContains(typedDirections[0], type)) {
                this.addDegreeWithDirection(degrees, relationshipGroup.outgoingReference(), relationshipGroup.outgoingCount(), nodeId, otherId);
            }
            if (typedDirections != null && !this.arrayContains(typedDirections[1], type)) continue;
            this.addDegreeWithDirection(degrees, relationshipGroup.incomingReference(), relationshipGroup.incomingCount(), nodeId, otherId);
        }
    }

    private void addDegreeWithDirection(List<Degree> degrees, long relationshipGroup, int degree, long nodeId, long otherId) {
        if (degree > 0) {
            degrees.add(new Degree(nodeId, relationshipGroup, degree, otherId));
        }
    }

    @UserFunction(value="apoc.node.labels")
    @Description(value="returns labels for (virtual) nodes")
    public List<String> labels(@Name(value="node") Node node) {
        if (node == null) {
            return null;
        }
        Iterator labels = node.getLabels().iterator();
        if (!labels.hasNext()) {
            return Collections.emptyList();
        }
        Label first = (Label)labels.next();
        if (!labels.hasNext()) {
            return Collections.singletonList(first.name());
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(first.name());
        labels.forEachRemaining(l -> result.add(l.name()));
        return result;
    }

    @UserFunction(value="apoc.node.id")
    @Description(value="returns id for (virtual) nodes")
    public Long id(@Name(value="node") Node node) {
        return node == null ? null : Long.valueOf(node.getId());
    }

    @UserFunction(value="apoc.rel.id")
    @Description(value="returns id for (virtual) relationships")
    public Long relId(@Name(value="rel") Relationship rel) {
        return rel == null ? null : Long.valueOf(rel.getId());
    }

    @UserFunction(value="apoc.rel.type")
    @Description(value="returns type for (virtual) relationships")
    public String type(@Name(value="rel") Relationship rel) {
        return rel == null ? null : rel.getType().name();
    }

    @UserFunction(value="apoc.any.properties")
    @Description(value="returns properties for virtual and real, nodes, rels and maps")
    public Map<String, Object> properties(@Name(value="thing") Object thing, @Name(value="keys", defaultValue="null") List<String> keys) {
        if (thing == null) {
            return null;
        }
        if (thing instanceof Map) {
            Map map = (Map)thing;
            if (keys != null) {
                map.keySet().retainAll(keys);
            }
            return map;
        }
        if (thing instanceof Entity) {
            if (keys == null) {
                return ((Entity)thing).getAllProperties();
            }
            return ((Entity)thing).getProperties(keys.toArray(new String[keys.size()]));
        }
        return null;
    }

    @UserFunction(value="apoc.any.property")
    @Description(value="returns property for virtual and real, nodes, rels and maps")
    public Object property(@Name(value="thing") Object thing, @Name(value="key") String key) {
        if (thing == null || key == null) {
            return null;
        }
        if (thing instanceof Map) {
            return ((Map)thing).get(key);
        }
        if (thing instanceof Entity) {
            return ((Entity)thing).getProperty(key, null);
        }
        return null;
    }

    @UserFunction(value="apoc.node.degree")
    @Description(value="apoc.node.degree(node, rel-direction-pattern) - returns total degrees of the given relationships in the pattern, can use '>' or '<' for all outgoing or incoming relationships")
    public long degree(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types) {
        if (types == null || types.isEmpty()) {
            return node.getDegree();
        }
        long degree = 0L;
        for (Pair<RelationshipType, Direction> pair : RelationshipTypeAndDirections.parse(types)) {
            degree += (long)this.getDegreeSafe(node, (RelationshipType)pair.first(), (Direction)pair.other());
        }
        return degree;
    }

    @UserFunction(value="apoc.node.degree.in")
    @Description(value="apoc.node.degree.in(node, relationshipName) - returns total number number of incoming relationships")
    public long degreeIn(@Name(value="node") Node node, @Name(value="types", defaultValue="") String type) {
        if (type == null || type.isEmpty()) {
            return node.getDegree(Direction.INCOMING);
        }
        return node.getDegree(RelationshipType.withName((String)type), Direction.INCOMING);
    }

    @UserFunction(value="apoc.node.degree.out")
    @Description(value="apoc.node.degree.out(node, relationshipName) - returns total number number of outgoing relationships")
    public long degreeOut(@Name(value="node") Node node, @Name(value="types", defaultValue="") String type) {
        if (type == null || type.isEmpty()) {
            return node.getDegree(Direction.OUTGOING);
        }
        return node.getDegree(RelationshipType.withName((String)type), Direction.OUTGOING);
    }

    @UserFunction(value="apoc.node.relationship.types")
    @Description(value="apoc.node.relationship.types(node, rel-direction-pattern) - returns a list of distinct relationship types")
    public List<String> relationshipTypes(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types) {
        if (node == null) {
            return null;
        }
        List relTypes = Iterables.asList((Iterable)Iterables.map(RelationshipType::name, (Iterable)node.getRelationshipTypes()));
        if (types == null || types.isEmpty()) {
            return relTypes;
        }
        ArrayList<String> result = new ArrayList<String>(relTypes.size());
        for (Pair<RelationshipType, Direction> p : RelationshipTypeAndDirections.parse(types)) {
            String name = ((RelationshipType)p.first()).name();
            if (!relTypes.contains(name) || !node.hasRelationship((Direction)p.other(), new RelationshipType[]{(RelationshipType)p.first()})) continue;
            result.add(name);
        }
        return result;
    }

    @UserFunction(value="apoc.nodes.relationship.types")
    @Description(value="apoc.nodes.relationship.types(node|nodes|id|[ids], rel-direction-pattern) - returns a list of maps where each one has two fields: `node` which is the node subject of the analysis and `types` which is a list of distinct relationship types")
    public List<Map<String, Object>> nodesRelationshipTypes(@Name(value="ids") Object ids, @Name(value="types", defaultValue="") String types) {
        if (ids == null) {
            return null;
        }
        return Util.nodeStream(this.tx, ids).map(node -> {
            List<String> relationshipTypes = this.relationshipTypes((Node)node, types);
            if (relationshipTypes == null) {
                return null;
            }
            return Util.map("node", node, "types", relationshipTypes);
        }).filter(e -> e != null).collect(Collectors.toList());
    }

    @UserFunction(value="apoc.node.relationships.exist")
    @Description(value="apoc.node.relationships.exist(node, rel-direction-pattern) - returns a map with rel-pattern, boolean for the given relationship patterns")
    public Map<String, Boolean> relationshipExists(@Name(value="node") Node node, @Name(value="types", defaultValue="") String types) {
        if (node == null || types == null || types.isEmpty()) {
            return null;
        }
        List relTypes = Iterables.asList((Iterable)Iterables.map(RelationshipType::name, (Iterable)node.getRelationshipTypes()));
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        for (Pair<RelationshipType, Direction> p : RelationshipTypeAndDirections.parse(types)) {
            String name = ((RelationshipType)p.first()).name();
            boolean hasRelationship = relTypes.contains(name) && node.hasRelationship((Direction)p.other(), new RelationshipType[]{(RelationshipType)p.first()});
            result.put(RelationshipTypeAndDirections.format(p), hasRelationship);
        }
        return result;
    }

    @UserFunction(value="apoc.nodes.relationships.exist")
    @Description(value="apoc.nodes.relationships.exist(node|nodes|id|[ids], rel-direction-pattern) - returns a list of maps where each one has two fields: `node` which is the node subject of the analysis and `exists` which is a map with rel-pattern, boolean for the given relationship patterns")
    public List<Map<String, Object>> nodesRelationshipExists(@Name(value="ids") Object ids, @Name(value="types", defaultValue="") String types) {
        if (ids == null) {
            return null;
        }
        return Util.nodeStream(this.tx, ids).map(node -> {
            Map<String, Boolean> existsMap = this.relationshipExists((Node)node, types);
            if (existsMap == null) {
                return null;
            }
            return Util.map("node", node, "exists", existsMap);
        }).filter(e -> e != null).collect(Collectors.toList());
    }

    @UserFunction
    @Description(value="apoc.nodes.isDense(node) - returns true if it is a dense node")
    public boolean isDense(@Name(value="node") Node node) {
        try (NodeCursor nodeCursor = this.ktx.cursors().allocateNodeCursor();){
            long id = node.getId();
            this.ktx.dataRead().singleNode(id, nodeCursor);
            if (nodeCursor.next()) {
                boolean bl = nodeCursor.isDense();
                return bl;
            }
            throw new IllegalArgumentException("node with id " + id + " does not exist.");
        }
    }

    private int getDegreeSafe(Node node, RelationshipType relType, Direction direction) {
        if (relType == null) {
            return node.getDegree(direction);
        }
        return node.getDegree(relType, direction);
    }

    static class Degree
    implements Comparable<Degree> {
        public final long node;
        private final long group;
        public final int degree;
        public final long other;

        public Degree(long node, long group, int degree, long other) {
            this.node = node;
            this.group = group;
            this.degree = degree;
            this.other = other;
        }

        @Override
        public int compareTo(Degree o) {
            return Integer.compare(this.degree, o.degree);
        }

        public boolean isConnected(Read read, RelationshipTraversalCursor relationship) {
            read.relationships(this.node, this.group, relationship);
            while (relationship.next()) {
                if (relationship.neighbourNodeReference() != this.other) continue;
                return true;
            }
            return false;
        }
    }
}

