/*
 * Decompiled with CFR 0.152.
 */
package apoc.hashing;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Fingerprinting {
    public static final String DIGEST_ALGORITHM = "MD5";
    @Context
    public Transaction tx;
    @Context
    public Log log;

    @UserFunction
    @Description(value="calculate a checksum (md5) over a node or a relationship. This deals gracefully with array properties. Two identical entities do share the same hash.")
    public String fingerprint(@Name(value="some object") Object thing, @Name(value="propertyExcludes", defaultValue="[]") List<String> excludedPropertyKeys) {
        return this.withMessageDigest(md -> this.fingerprint((DiagnosingMessageDigestDecorator)md, thing, excludedPropertyKeys));
    }

    private void fingerprint(DiagnosingMessageDigestDecorator md, Object thing, List<String> excludedPropertyKeys) {
        if (thing instanceof Node) {
            this.fingerprintNode(md, (Node)thing, excludedPropertyKeys);
        } else if (thing instanceof Relationship) {
            this.fingerprintRelationship(md, (Relationship)thing, excludedPropertyKeys);
        } else if (thing instanceof Map) {
            Map map = (Map)thing;
            map.entrySet().stream().filter(e -> !excludedPropertyKeys.contains(e.getKey())).sorted(Map.Entry.comparingByKey()).forEachOrdered(entry -> {
                md.update(((String)entry.getKey()).getBytes());
                md.update(this.fingerprint(entry.getValue(), excludedPropertyKeys).getBytes());
            });
        } else if (thing instanceof List) {
            List list = (List)thing;
            list.stream().forEach(o -> this.fingerprint(md, o, excludedPropertyKeys));
        } else {
            md.update(this.convertValueToString(thing).getBytes());
        }
    }

    @UserFunction
    @Description(value="calculate a checksum (md5) over a the full graph. Be aware that this function does use in-memomry datastructures depending on the size of your graph.")
    public String fingerprintGraph(@Name(value="propertyExcludes", defaultValue="[]") List<String> excludedPropertyKeys) {
        return this.withMessageDigest(messageDigest -> {
            Map idToNodeHash = this.tx.getAllNodes().stream().collect(Collectors.toMap(Entity::getId, node -> this.fingerprint(node, excludedPropertyKeys), (aLong, aLong2) -> {
                throw new RuntimeException();
            }, () -> new TreeMap()));
            Map nodeHashToId = idToNodeHash.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (o, o2) -> {
                throw new RuntimeException();
            }, () -> new TreeMap()));
            nodeHashToId.entrySet().stream().forEach(entry -> {
                messageDigest.update(((String)entry.getKey()).getBytes());
                Node node = this.tx.getNodeById(((Long)entry.getValue()).longValue());
                List endNodeRelationshipHashTuples = StreamSupport.stream(node.getRelationships(Direction.OUTGOING).spliterator(), false).map(relationship -> {
                    String endNodeHash = (String)idToNodeHash.get(relationship.getEndNodeId());
                    String relationshipHash = this.fingerprint(relationship, excludedPropertyKeys);
                    return new EndNodeRelationshipHashTuple(endNodeHash, relationshipHash);
                }).collect(Collectors.toList());
                endNodeRelationshipHashTuples.stream().sorted().forEach(endNodeRelationshipHashTuple -> {
                    messageDigest.update(endNodeRelationshipHashTuple.getEndNodeHash().getBytes());
                    messageDigest.update(endNodeRelationshipHashTuple.getRelationshipHash().getBytes());
                });
            });
        });
    }

    private void fingerprintNode(DiagnosingMessageDigestDecorator md, Node node, List<String> excludedPropertyKeys) {
        StreamSupport.stream(node.getLabels().spliterator(), false).map(Label::name).sorted().map(String::getBytes).forEach(md::update);
        this.fingerprint(md, node.getAllProperties(), excludedPropertyKeys);
    }

    private void fingerprintRelationship(DiagnosingMessageDigestDecorator md, Relationship rel, List<String> excludedPropertyKeys) {
        md.update(rel.getType().name().getBytes());
        this.fingerprint(md, rel.getAllProperties(), excludedPropertyKeys);
    }

    private String withMessageDigest(Consumer<DiagnosingMessageDigestDecorator> consumer) {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            DiagnosingMessageDigestDecorator dmd = new DiagnosingMessageDigestDecorator(md);
            consumer.accept(dmd);
            return Fingerprinting.renderAsHex(md.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String renderAsHex(byte[] content) {
        Formatter formatter = new Formatter();
        for (byte b : content) {
            formatter.format("%02X", b);
        }
        return formatter.toString();
    }

    private String convertValueToString(Object value) {
        if (value.getClass().isArray()) {
            return this.nativeArrayToString(value);
        }
        return value.toString();
    }

    private String nativeArrayToString(Object value) {
        StringBuilder sb = new StringBuilder();
        if (value instanceof String[]) {
            for (String s : (String[])value) {
                sb.append(s);
            }
        } else if (value instanceof double[]) {
            for (double d : (double[])value) {
                sb.append(d);
            }
        } else if (value instanceof long[]) {
            long[] lArray = (long[])value;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                double l = lArray[i];
                sb.append(l);
            }
        } else {
            throw new UnsupportedOperationException("cannot yet deal with " + value.getClass().getName());
        }
        return sb.toString();
    }

    private class DiagnosingMessageDigestDecorator {
        private final MessageDigest delegate;

        public DiagnosingMessageDigestDecorator(MessageDigest delegate) {
            this.delegate = delegate;
        }

        public void update(byte[] value) {
            if (Fingerprinting.this.log.isDebugEnabled()) {
                Fingerprinting.this.log.debug("adding to message digest {}", new Object[]{new String(value)});
            }
            this.delegate.update(value);
        }
    }

    private static class EndNodeRelationshipHashTuple
    implements Comparable {
        private final String endNodeHash;
        private final String relationshipHash;

        public EndNodeRelationshipHashTuple(String endNodeHash, String relationshipHash) {
            this.endNodeHash = endNodeHash;
            this.relationshipHash = relationshipHash;
        }

        public int compareTo(Object o) {
            EndNodeRelationshipHashTuple other = (EndNodeRelationshipHashTuple)o;
            int res = this.endNodeHash.compareTo(other.endNodeHash);
            if (res == 0) {
                res = this.relationshipHash.compareTo(other.relationshipHash);
            }
            return res;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndNodeRelationshipHashTuple that = (EndNodeRelationshipHashTuple)o;
            if (this.endNodeHash != null ? !this.endNodeHash.equals(that.endNodeHash) : that.endNodeHash != null) {
                return false;
            }
            return this.relationshipHash != null ? this.relationshipHash.equals(that.relationshipHash) : that.relationshipHash == null;
        }

        public int hashCode() {
            int result = this.endNodeHash != null ? this.endNodeHash.hashCode() : 0;
            result = 31 * result + (this.relationshipHash != null ? this.relationshipHash.hashCode() : 0);
            return result;
        }

        public String getEndNodeHash() {
            return this.endNodeHash;
        }

        public String getRelationshipHash() {
            return this.relationshipHash;
        }
    }
}

