/*
 * Decompiled with CFR 0.152.
 */
package apoc.graph.util;

import apoc.util.Util;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GraphsConfig {
    private static final Pattern MAPPING_PATTERN = Pattern.compile("^(\\w+\\s*(?::\\s*(?:\\w+)\\s*)*)\\s*(?:\\{\\s*(-?[\\*\\w!@\\.]+\\s*(?:,\\s*-?[!@\\w\\*\\.]+\\s*)*)\\})?$");
    private boolean write;
    private String labelField;
    private String idField;
    private boolean generateId;
    private String defaultLabel;
    private Map<String, GraphMapping> mappings;
    private boolean skipValidation;

    public GraphsConfig(Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.write = Util.toBoolean(config.getOrDefault("write", false));
        this.generateId = Util.toBoolean(config.getOrDefault("generateId", true));
        this.idField = config.getOrDefault("idField", "id").toString();
        this.labelField = config.getOrDefault("labelField", "type").toString();
        this.defaultLabel = config.getOrDefault("defaultLabel", "DocNode").toString();
        this.mappings = this.toMappings(config.getOrDefault("mappings", Collections.emptyMap()));
        this.skipValidation = Util.toBoolean(config.getOrDefault("skipValidation", false));
    }

    private Map<String, GraphMapping> toMappings(Map<String, String> mappings) {
        return mappings.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, GraphMapping>((String)e.getKey(), GraphMapping.from((String)e.getValue()))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (GraphMapping)e.getValue()));
    }

    public boolean isWrite() {
        return this.write;
    }

    public String getLabelField() {
        return this.labelField;
    }

    public String getIdField() {
        return this.idField;
    }

    public boolean isGenerateId() {
        return this.generateId;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public boolean isSkipValidation() {
        return this.skipValidation;
    }

    public List<String> valueObjectForPath(String path) {
        return this.mappings.getOrDefault(path, GraphMapping.EMPTY).getValueObjects();
    }

    public List<String> idsForPath(String path) {
        return this.mappings.getOrDefault(path, GraphMapping.EMPTY).getIds();
    }

    public List<String> labelsForPath(String path) {
        return this.mappings.getOrDefault(path, GraphMapping.EMPTY).getLabels();
    }

    public List<String> propertiesForPath(String path) {
        if (this.allPropertiesForPath(path)) {
            return Collections.emptyList();
        }
        List pathProperties = this.mappings.keySet().stream().filter(key -> key.startsWith(path)).map(key -> path.length() >= key.length() ? "" : key.substring(path.length() + 1)).map(key -> key.split("\\.")[0]).filter(key -> !key.isEmpty()).collect(Collectors.toList());
        List<String> properties = this.mappings.getOrDefault(path, GraphMapping.EMPTY).getProperties();
        properties.addAll(pathProperties);
        return properties;
    }

    public boolean allPropertiesForPath(String path) {
        return this.mappings.getOrDefault(path, GraphMapping.EMPTY).isAllProps();
    }

    public static class GraphMapping {
        private static final String IDS = "ids";
        private static final String VALUE_OBJECTS = "valueObjects";
        private static final String PROPERTIES = "properties";
        private static final String WILDCARD = "*";
        private List<String> valueObjects = new ArrayList<String>();
        private List<String> ids = new ArrayList<String>();
        private List<String> properties = new ArrayList<String>();
        private List<String> labels = new ArrayList<String>();
        private boolean allProps = true;
        static final GraphMapping EMPTY = new GraphMapping();

        GraphMapping(List<String> valueObjects, List<String> ids, List<String> properties, List<String> labels, boolean allProps) {
            this.allProps = allProps;
            if (valueObjects != null) {
                this.valueObjects.addAll(valueObjects);
            }
            if (ids != null) {
                this.ids.addAll(ids);
            }
            if (labels != null) {
                this.labels.addAll(labels);
            }
            if (!this.allProps) {
                if (properties != null) {
                    this.properties.addAll(properties);
                }
                this.properties.addAll(this.ids);
                this.properties.addAll(this.valueObjects);
            }
        }

        GraphMapping() {
        }

        public List<String> getValueObjects() {
            return this.valueObjects;
        }

        public List<String> getIds() {
            return this.ids;
        }

        public List<String> getProperties() {
            return this.properties;
        }

        public List<String> getLabels() {
            return this.labels;
        }

        public boolean isAllProps() {
            return this.allProps;
        }

        public static GraphMapping from(String pattern) {
            Matcher matcher = MAPPING_PATTERN.matcher(pattern);
            if (!matcher.matches()) {
                throw new RuntimeException("The provided pattern " + pattern + " does not match the requirements");
            }
            List<String> labels = Arrays.asList(matcher.group(1).split(":"));
            AtomicBoolean allProps = new AtomicBoolean(false);
            Map map = Stream.of(matcher.group(2).split(",")).map(s -> {
                String key;
                String value = s.trim();
                if (value.startsWith("@")) {
                    key = VALUE_OBJECTS;
                    value = value.substring(1);
                } else if (value.startsWith("!")) {
                    key = IDS;
                    value = value.substring(1);
                } else {
                    key = PROPERTIES;
                }
                if (WILDCARD.equals(value) && key.equals(PROPERTIES)) {
                    allProps.set(true);
                    return null;
                }
                return new AbstractMap.SimpleEntry<String, String>(key, value);
            }).filter(e -> e != null).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
            return new GraphMapping(map.get(VALUE_OBJECTS), map.get(IDS), map.get(PROPERTIES), labels, allProps.get());
        }
    }
}

