/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.xls;

import java.util.Collections;
import java.util.Map;

public class XlsExportConfig {
    public static final int DEFAULT_BATCH_SIZE = 20000;
    private final int batchSize;
    private final Map<String, Object> config;
    private final String headerNodeId;
    private final String headerRelationshipId;
    private final String headerStartNodeId;
    private final String headerEndNodeId;
    private final String arrayDelimiter;
    private final String dateTimeStyle;
    private final String dateStyle;

    public XlsExportConfig(Map<String, Object> c) {
        this.config = c != null ? c : Collections.emptyMap();
        this.headerNodeId = (String)this.config.getOrDefault("headerNodeId", "<nodeId>");
        this.headerRelationshipId = (String)this.config.getOrDefault("headerRelationshipId", "<relationshipId>");
        this.headerStartNodeId = (String)this.config.getOrDefault("headerStartNodeId", "<startNodeId>");
        this.headerEndNodeId = (String)this.config.getOrDefault("headerEndNodeId", "<endNodeId>");
        this.arrayDelimiter = (String)this.config.getOrDefault("arrayDelimiter", ";");
        this.dateTimeStyle = (String)this.config.getOrDefault("dateTimeStyle", "yyyy-mm-dd hh:mm:ss");
        this.dateStyle = (String)this.config.getOrDefault("dateStyle", "yyyy-mm-dd");
        this.batchSize = ((Number)this.config.getOrDefault("batchSize", 20000)).intValue();
    }

    public String getHeaderNodeId() {
        return this.headerNodeId;
    }

    public String getHeaderRelationshipId() {
        return this.headerRelationshipId;
    }

    public String getHeaderStartNodeId() {
        return this.headerStartNodeId;
    }

    public String getHeaderEndNodeId() {
        return this.headerEndNodeId;
    }

    public String getArrayDelimiter() {
        return this.arrayDelimiter;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getDateTimeStyle() {
        return this.dateTimeStyle;
    }

    public String getDateStyle() {
        return this.dateStyle;
    }
}

