/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.xls;

import apoc.ApocConfig;
import apoc.Description;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.util.ProgressReporter;
import apoc.export.xls.XlsExportConfig;
import apoc.result.ProgressInfo;
import apoc.util.Util;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class ExportXls {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public ApocConfig apocConfig;

    @Procedure
    @Description(value="apoc.export.xls.all(file,config) - exports whole database as xls to the provided file")
    public Stream<ProgressInfo> all(@Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.tx), Util.relCount(this.tx));
        return this.exportXls(fileName, source, new DatabaseSubGraph(this.tx), config);
    }

    @Procedure
    @Description(value="apoc.export.xls.data(nodes,rels,file,config) - exports given nodes and relationships as xls to the provided file")
    public Stream<ProgressInfo> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportXls(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), config);
    }

    @Procedure
    @Description(value="apoc.export.xls.graph(graph,file,config) - exports given graph object as xls to the provided file")
    public Stream<ProgressInfo> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportXls(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), config);
    }

    @Procedure
    @Description(value="apoc.export.xls.query(query,file,{config,...,params:{params}}) - exports results from the cypher statement as xls to the provided file")
    public Stream<ProgressInfo> query(@Name(value="query") String query, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) throws Exception {
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(query, params);
        String source = String.format("statement: cols(%d)", result.columns().size());
        return this.exportXls(fileName, source, result, config);
    }

    /*
     * Exception decompiling
     */
    private Stream<ProgressInfo> exportXls(@Name(value="file") String fileName, String source, Object data, Map<String, Object> configMap) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void dumpResult(Result result, XlsExportConfig config, SXSSFWorkbook wb, Map<Class, CellStyle> styles) {
        SXSSFSheet sheet = wb.createSheet();
        sheet.trackAllColumnsForAutoSizing();
        int columnNum = 0;
        int rowNum = 0;
        SXSSFRow headerRow = sheet.createRow(rowNum++);
        for (String header : result.columns()) {
            Cell cell = headerRow.createCell(columnNum);
            sheet.autoSizeColumn(columnNum);
            cell.setCellValue(header);
            ++columnNum;
        }
        while (result.hasNext()) {
            Map map = result.next();
            SXSSFRow row = sheet.createRow(rowNum++);
            columnNum = 0;
            for (String header : result.columns()) {
                columnNum = this.amendCell((Row)row, columnNum, map.get(header), config, styles);
            }
        }
    }

    private void dumpSubGraph(SubGraph subgraph, XlsExportConfig config, ProgressReporter reporter, SXSSFWorkbook wb, Map<Class, CellStyle> styles) {
        HashMap<String, Triple<SXSSFSheet, List<String>, List<String>>> sheetAndPropsForName = new HashMap<String, Triple<SXSSFSheet, List<String>, List<String>>>();
        for (Node node : subgraph.getNodes()) {
            for (Label label : node.getLabels()) {
                String labelName = label.name();
                this.createRowForEntity((Workbook)wb, sheetAndPropsForName, (Entity)node, labelName, reporter, config, styles);
            }
        }
        for (Relationship relationship : subgraph.getRelationships()) {
            String relationshipType = relationship.getType().name();
            this.createRowForEntity((Workbook)wb, sheetAndPropsForName, (Entity)relationship, relationshipType, reporter, config, styles);
        }
        for (Triple triple : sheetAndPropsForName.values()) {
            Sheet sheet = (Sheet)triple.getLeft();
            List magicKeys = (List)triple.getMiddle();
            List keys = (List)triple.getRight();
            Row row = sheet.getRow(0);
            int cellNum = 0;
            for (String key : ListUtils.union((List)magicKeys, (List)keys)) {
                sheet.autoSizeColumn(cellNum);
                Cell cell = row.createCell(cellNum++);
                cell.setCellValue(key);
            }
        }
    }

    private Map<Class, CellStyle> buildCellStyles(XlsExportConfig config, SXSSFWorkbook wb) {
        CreationHelper createHelper = wb.getCreationHelper();
        CellStyle dateTimeCellStyle = wb.createCellStyle();
        dateTimeCellStyle.setDataFormat(createHelper.createDataFormat().getFormat(config.getDateTimeStyle()));
        CellStyle dateCellStyle = wb.createCellStyle();
        dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat(config.getDateStyle()));
        HashMap<Class, CellStyle> styles = new HashMap<Class, CellStyle>();
        styles.put(ZonedDateTime.class, dateTimeCellStyle);
        styles.put(LocalDate.class, dateCellStyle);
        return styles;
    }

    private void createRowForEntity(Workbook wb, Map<String, Triple<SXSSFSheet, List<String>, List<String>>> sheetAndPropsForName, Entity Entity2, String sheetName, ProgressReporter reporter, XlsExportConfig config, Map<Class, CellStyle> styles) {
        Cell idCell;
        Triple triple = sheetAndPropsForName.computeIfAbsent(sheetName, s -> {
            SXSSFSheet sheet = (SXSSFSheet)wb.createSheet(sheetName);
            sheet.trackAllColumnsForAutoSizing();
            sheet.createRow(0);
            return Triple.of((Object)sheet, Entity2 instanceof Node ? Arrays.asList(config.getHeaderNodeId()) : Arrays.asList(config.getHeaderRelationshipId(), config.getHeaderStartNodeId(), config.getHeaderEndNodeId()), new ArrayList());
        });
        Sheet sheet = (Sheet)triple.getLeft();
        List propertyKeys = (List)triple.getRight();
        int lastRowNum = sheet.getLastRowNum();
        Row row = sheet.createRow(lastRowNum + 1);
        int cellNum = 0;
        TreeMap props = new TreeMap(Entity2.getAllProperties());
        if (Entity2 instanceof Node) {
            Node node = (Node)Entity2;
            idCell = row.createCell(cellNum++);
            idCell.setCellValue(Long.valueOf(node.getId()).doubleValue());
            reporter.update(1L, 0L, props.size());
        } else if (Entity2 instanceof Relationship) {
            Relationship relationship = (Relationship)Entity2;
            idCell = row.createCell(cellNum++);
            idCell.setCellValue(Long.valueOf(relationship.getId()).doubleValue());
            Cell fromCell = row.createCell(cellNum++);
            fromCell.setCellValue(Long.valueOf(relationship.getStartNodeId()).doubleValue());
            Cell toCell = row.createCell(cellNum++);
            toCell.setCellValue(Long.valueOf(relationship.getEndNodeId()).doubleValue());
            reporter.update(0L, 1L, props.size());
        }
        for (String key : propertyKeys) {
            cellNum = this.amendCell(row, cellNum, props.remove(key), config, styles);
        }
        for (String key : props.keySet()) {
            propertyKeys.add(key);
            cellNum = this.amendCell(row, cellNum, props.get(key), config, styles);
        }
    }

    private int amendCell(Row row, int cellNum, Object value, XlsExportConfig config, Map<Class, CellStyle> styles) {
        Cell cell = row.createCell(cellNum++);
        if (value == null) {
            cell.setCellType(CellType.BLANK);
        } else {
            CellStyle cellStyle = styles.get(value.getClass());
            if (cellStyle != null) {
                cell.setCellStyle(cellStyle);
            }
            if (value instanceof String) {
                cell.setCellValue((String)value);
            } else if (value instanceof Number) {
                cell.setCellValue(((Number)value).doubleValue());
            } else if (value instanceof Boolean) {
                cell.setCellValue(((Boolean)value).booleanValue());
            } else if (value instanceof String[]) {
                String[] values = (String[])value;
                cell.setCellValue(Arrays.stream(values).collect(Collectors.joining(config.getArrayDelimiter())));
            } else if (value instanceof long[]) {
                long[] values = (long[])value;
                cell.setCellValue(Arrays.stream(values).mapToObj(Long::toString).collect(Collectors.joining(config.getArrayDelimiter())));
            } else if (value instanceof double[]) {
                double[] values = (double[])value;
                cell.setCellValue(Arrays.stream(values).mapToObj(Double::toString).collect(Collectors.joining(config.getArrayDelimiter())));
            } else if (value instanceof List) {
                List values = (List)value;
                String collect = values.stream().map(x -> x.toString()).collect(Collectors.joining(config.getArrayDelimiter()));
                cell.setCellValue(collect);
            } else if (value instanceof LocalDate) {
                LocalDate localDate = (LocalDate)value;
                cell.setCellValue(Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
            } else if (value instanceof ZonedDateTime) {
                ZonedDateTime zondedDateTime = (ZonedDateTime)value;
                cell.setCellValue(Date.from(zondedDateTime.toInstant()));
            } else {
                cell.setCellValue(value.toString());
            }
        }
        return cellNum;
    }
}

