/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.util.Reporter;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;

public class BatchTransaction
implements AutoCloseable {
    private final GraphDatabaseService gdb;
    private final int batchSize;
    private final Reporter reporter;
    Transaction tx;
    int count = 0;
    int batchCount = 0;

    public BatchTransaction(GraphDatabaseService gdb, int batchSize, Reporter reporter) {
        this.gdb = gdb;
        this.batchSize = batchSize;
        this.reporter = reporter;
        this.tx = this.beginTx();
    }

    public void increment() {
        ++this.count;
        ++this.batchCount;
        if (this.batchCount >= this.batchSize) {
            this.doCommit(true);
        }
    }

    public void commit() {
        this.doCommit(true);
    }

    public int getCount() {
        return this.count;
    }

    public void manualCommit(boolean log) {
        this.doCommit(log);
    }

    private void doCommit(boolean log) {
        this.tx.commit();
        this.tx.close();
        if (log && this.reporter != null) {
            this.reporter.progress("commit after " + this.count + " row(s) ");
        }
        this.tx = this.beginTx();
        this.batchCount = 0;
    }

    private Transaction beginTx() {
        return this.gdb.beginTx();
    }

    @Override
    public void close() {
        if (this.tx != null) {
            this.tx.commit();
            this.tx.close();
            if (this.reporter != null) {
                this.reporter.progress("finish after " + this.count + " row(s) ");
            }
        }
    }

    public Transaction getTransaction() {
        return this.tx;
    }
}

