/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.json;

import apoc.export.cypher.ExportFileManager;
import apoc.export.json.JsonFormatSerializer;
import apoc.export.util.ExportConfig;
import apoc.export.util.Format;
import apoc.export.util.Reporter;
import apoc.meta.Meta;
import apoc.result.ProgressInfo;
import apoc.util.JsonUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;

public class JsonFormat
implements Format {
    private final GraphDatabaseService db;

    public JsonFormat(GraphDatabaseService db) {
        this.db = db;
    }

    @Override
    public ProgressInfo load(Reader reader, Reporter reporter, ExportConfig config) throws Exception {
        return null;
    }

    /*
     * Exception decompiling
     */
    private ProgressInfo dump(Writer writer, Reporter reporter, Consumer<JsonGenerator> consumer) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ProgressInfo dump(SubGraph graph, ExportFileManager writer, Reporter reporter, ExportConfig config) throws Exception {
        Consumer<JsonGenerator> consumer = jsonGenerator -> {
            try {
                this.writeNodes(graph.getNodes(), reporter, (JsonGenerator)jsonGenerator, config);
                this.writeRels(graph.getRelationships(), reporter, (JsonGenerator)jsonGenerator, config);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this.dump(writer.getPrintWriter("json"), reporter, consumer);
    }

    public ProgressInfo dump(Result result, ExportFileManager writer, Reporter reporter, ExportConfig config) throws Exception {
        Consumer<JsonGenerator> consumer = jsonGenerator -> {
            try {
                String[] header = result.columns().toArray(new String[result.columns().size()]);
                result.accept(row -> {
                    this.writeJsonResult(reporter, header, (JsonGenerator)jsonGenerator, row, config);
                    reporter.nextRow();
                    return true;
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this.dump(writer.getPrintWriter("json"), reporter, consumer);
    }

    private JsonGenerator getJsonGenerator(Writer writer) throws IOException {
        JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer).setCodec((ObjectCodec)JsonUtil.OBJECT_MAPPER).setPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter("\n"));
        return jsonGenerator;
    }

    private void writeNodes(Iterable<Node> nodes, Reporter reporter, JsonGenerator jsonGenerator, ExportConfig config) throws IOException {
        for (Node node : nodes) {
            this.writeNode(reporter, jsonGenerator, node, config);
        }
    }

    private void writeNode(Reporter reporter, JsonGenerator jsonGenerator, Node node, ExportConfig config) throws IOException {
        Map allProperties = node.getAllProperties();
        JsonFormatSerializer.DEFAULT.writeNode(jsonGenerator, node, config);
        reporter.update(1L, 0L, allProperties.size());
    }

    private void writeRels(Iterable<Relationship> rels, Reporter reporter, JsonGenerator jsonGenerator, ExportConfig config) throws IOException {
        for (Relationship rel : rels) {
            this.writeRel(reporter, jsonGenerator, rel, config);
        }
    }

    private void writeRel(Reporter reporter, JsonGenerator jsonGenerator, Relationship rel, ExportConfig config) throws IOException {
        Map allProperties = rel.getAllProperties();
        JsonFormatSerializer.DEFAULT.writeRelationship(jsonGenerator, rel, config);
        reporter.update(0L, 1L, allProperties.size());
    }

    private void writeJsonResult(Reporter reporter, String[] header, JsonGenerator jsonGenerator, Result.ResultRow row, ExportConfig config) throws IOException {
        jsonGenerator.writeStartObject();
        for (int col = 0; col < header.length; ++col) {
            String keyName = header[col];
            Object value = row.get(keyName);
            this.write(reporter, jsonGenerator, config, keyName, value, true);
        }
        jsonGenerator.writeEndObject();
    }

    private void write(Reporter reporter, JsonGenerator jsonGenerator, ExportConfig config, String keyName, Object value, boolean writeKey) throws IOException {
        Meta.Types type = Meta.Types.of(value);
        switch (type) {
            case NODE: {
                this.writeFieldName(jsonGenerator, keyName, writeKey);
                this.writeNode(reporter, jsonGenerator, (Node)value, config);
                break;
            }
            case RELATIONSHIP: {
                this.writeFieldName(jsonGenerator, keyName, writeKey);
                this.writeRel(reporter, jsonGenerator, (Relationship)value, config);
                break;
            }
            case PATH: {
                this.writeFieldName(jsonGenerator, keyName, writeKey);
                this.writePath(reporter, jsonGenerator, config, (Path)value);
                break;
            }
            case MAP: {
                if (writeKey) {
                    jsonGenerator.writeObjectFieldStart(keyName);
                } else {
                    jsonGenerator.writeStartObject();
                    writeKey = true;
                }
                HashMap map = (HashMap)value;
                for (Map.Entry entry : map.entrySet()) {
                    this.write(reporter, jsonGenerator, config, (String)entry.getKey(), entry.getValue(), writeKey);
                }
                jsonGenerator.writeEndObject();
                break;
            }
            case LIST: {
                Object[] list;
                if (writeKey) {
                    jsonGenerator.writeArrayFieldStart(keyName);
                } else {
                    jsonGenerator.writeStartArray();
                }
                for (Object elem : list = value.getClass().isArray() ? (Object[])value : ((List)value).toArray()) {
                    this.write(reporter, jsonGenerator, config, keyName, elem, false);
                }
                jsonGenerator.writeEndArray();
                break;
            }
            default: {
                JsonFormatSerializer.DEFAULT.serializeProperty(jsonGenerator, keyName, value, writeKey);
                reporter.update(0L, 0L, 1L);
            }
        }
    }

    private void writeFieldName(JsonGenerator jsonGenerator, String keyName, boolean writeKey) throws IOException {
        if (writeKey) {
            jsonGenerator.writeFieldName(keyName);
        }
    }

    private void writePath(Reporter reporter, JsonGenerator jsonGenerator, ExportConfig config, Path path) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField("length", (Object)path.length());
        jsonGenerator.writeArrayFieldStart("rels");
        this.writeRels(path.relationships(), reporter, jsonGenerator, config);
        jsonGenerator.writeEndArray();
        jsonGenerator.writeArrayFieldStart("nodes");
        this.writeNodes(path.nodes(), reporter, jsonGenerator, config);
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }
}

