/*
 * Decompiled with CFR 0.152.
 */
package apoc.couchbase.document;

import apoc.couchbase.document.CouchbaseDocument;
import apoc.couchbase.document.CouchbaseUtils;
import com.couchbase.client.java.document.JsonDocument;
import com.couchbase.client.java.document.json.JsonObject;
import java.util.HashMap;
import java.util.Map;

public class CouchbaseJsonDocument
implements CouchbaseDocument<Map<String, Object>> {
    public String id;
    public long expiry;
    public long cas;
    public Map<String, Object> mutationToken;
    public Map<String, Object> content;

    public CouchbaseJsonDocument(JsonDocument jsonDocument) {
        Map<String, Object> map;
        this.id = jsonDocument.id();
        this.expiry = jsonDocument.expiry();
        this.cas = jsonDocument.cas();
        this.mutationToken = CouchbaseUtils.convertMutationTokenToMap(jsonDocument.mutationToken());
        if (jsonDocument.content() != null) {
            this.content = ((JsonObject)jsonDocument.content()).toMap();
            map = this.content;
        } else {
            map = new HashMap<String, Object>();
        }
        this.content = map;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Map<String, Object> getContent() {
        return this.content;
    }

    @Override
    public long getCas() {
        return this.cas;
    }

    @Override
    public long getExpiry() {
        return this.expiry;
    }

    @Override
    public Map<String, Object> getMutationToken() {
        return this.mutationToken;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName() + " {");
        sb.append("id='").append(this.getId()).append('\'');
        sb.append(", cas=").append(this.getCas());
        sb.append(", expiry=").append(this.getExpiry());
        sb.append(", content=").append(this.getContent());
        sb.append(", mutationToken=").append(this.getMutationToken());
        sb.append('}');
        return sb.toString();
    }
}

