/*
 * Decompiled with CFR 0.152.
 */
package apoc.cache;

import apoc.ApocConfig;
import apoc.result.KeyValueResult;
import apoc.result.ObjectResult;
import apoc.util.Util;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Static {
    @Context
    public GraphDatabaseAPI db;
    @Context
    public ApocConfig apocConfig;
    private static Map<String, Object> storage = new HashMap<String, Object>();

    @Procedure(value="apoc.static.get")
    @Deprecated
    @Description(value="apoc.static.get(name) - returns statically stored value from config (apoc.static.<key>) or server lifetime storage")
    public Stream<ObjectResult> getProcedure(@Name(value="key") String key) {
        return Stream.of(new ObjectResult(storage.getOrDefault(key, this.fromConfig(key))));
    }

    @UserFunction(value="apoc.static.get")
    @Description(value="apoc.static.get(name) - returns statically stored value from config (apoc.static.<key>) or server lifetime storage")
    public Object get(@Name(value="key") String key) {
        return storage.getOrDefault(key, this.fromConfig(key));
    }

    @UserFunction(value="apoc.static.getAll")
    @Description(value="apoc.static.getAll(prefix) - returns statically stored values from config (apoc.static.<prefix>.*) or server lifetime storage")
    public Map<String, Object> getAll(@Name(value="prefix") String prefix) {
        return this.getFromConfigAndStorage(prefix);
    }

    private HashMap<String, Object> getFromConfigAndStorage(@Name(value="prefix") String prefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object configPrefix = prefix.isEmpty() ? "apoc.static" : "apoc.static." + prefix;
        Iterators.stream(this.apocConfig.getKeys((String)configPrefix)).forEach(arg_0 -> this.lambda$getFromConfigAndStorage$0(result, (String)configPrefix, arg_0));
        result.putAll(Util.subMap(storage, prefix));
        return result;
    }

    @Procedure(value="apoc.static.list")
    @Description(value="apoc.static.list(prefix) - returns statically stored values from config (apoc.static.<prefix>.*) or server lifetime storage")
    public Stream<KeyValueResult> list(@Name(value="prefix") String prefix) {
        HashMap<String, Object> result = this.getFromConfigAndStorage(prefix);
        return result.entrySet().stream().map(e -> new KeyValueResult((String)e.getKey(), e.getValue()));
    }

    private Object fromConfig(@Name(value="key") String key) {
        return this.apocConfig.getString("apoc.static." + key);
    }

    @Procedure(value="apoc.static.set")
    @Description(value="apoc.static.set(name, value) - stores value under key for server lifetime storage, returns previously stored or configured value")
    public Stream<ObjectResult> set(@Name(value="key") String key, @Name(value="value") Object value) {
        Object previous = value == null ? storage.remove(key) : storage.put(key, value);
        return Stream.of(new ObjectResult(previous == null ? this.fromConfig(key) : previous));
    }

    public static void clear() {
        storage.clear();
    }

    private /* synthetic */ void lambda$getFromConfigAndStorage$0(HashMap result, String configPrefix, String s) {
        result.put(s.substring(configPrefix.length() + 1), this.apocConfig.getString(s));
    }
}

