/*
 * Decompiled with CFR 0.152.
 */
package apoc.refactor;

import apoc.Description;
import apoc.refactor.NodeRefactorResult;
import apoc.refactor.RelationshipRefactorResult;
import apoc.result.NodeResult;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;

public class GraphRefactoring {
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    private Stream<NodeRefactorResult> doCloneNodes(@Name(value="nodes") List<Node> nodes, @Name(value="withRelationships") boolean withRelationships) {
        return nodes.stream().map(node -> {
            NodeRefactorResult result = new NodeRefactorResult(node.getId());
            try {
                Node copy = this.copyProperties((PropertyContainer)node, (PropertyContainer)this.copyLabels((Node)node, this.db.createNode()));
                if (withRelationships) {
                    this.copyRelationships((Node)node, copy, false);
                }
                return result.withOther(copy);
            }
            catch (Exception e) {
                return result.withError(e);
            }
        });
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.refactor.cloneNodes([node1,node2,...]) clone nodes with their labels and properties")
    public Stream<NodeRefactorResult> cloneNodes(@Name(value="nodes") List<Node> nodes) {
        return this.doCloneNodes(nodes, false);
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.refactor.cloneNodesWithRelationships([node1,node2,...]) clone nodes with their labels, properties and relationships")
    public Stream<NodeRefactorResult> cloneNodesWithRelationships(@Name(value="nodes") List<Node> nodes) {
        return this.doCloneNodes(nodes, true);
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.refactor.mergeNodes([node1,node2]) merge nodes onto first in list")
    public Stream<NodeResult> mergeNodes(@Name(value="nodes") List<Node> nodes) {
        if (nodes.isEmpty()) {
            return Stream.empty();
        }
        Iterator<Node> it = nodes.iterator();
        Node first = it.next();
        while (it.hasNext()) {
            Node other = it.next();
            this.mergeNodes(other, first, true);
        }
        return Stream.of(new NodeResult(first));
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.refactor.setType(rel, 'NEW-TYPE') change relationship-type")
    public Stream<RelationshipRefactorResult> setType(@Name(value="relationship") Relationship rel, @Name(value="newType") String newType) {
        RelationshipRefactorResult result = new RelationshipRefactorResult(rel.getId());
        try {
            Relationship newRel = rel.getStartNode().createRelationshipTo(rel.getEndNode(), RelationshipType.withName((String)newType));
            this.copyProperties(rel, newRel);
            rel.delete();
            return Stream.of(result.withOther(newRel));
        }
        catch (Exception e) {
            return Stream.of(result.withError(e));
        }
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.refactor.to(rel, endNode) redirect relationship to use new end-node")
    public Stream<RelationshipRefactorResult> to(@Name(value="relationship") Relationship rel, @Name(value="newNode") Node newNode) {
        RelationshipRefactorResult result = new RelationshipRefactorResult(rel.getId());
        try {
            Relationship newRel = rel.getStartNode().createRelationshipTo(newNode, rel.getType());
            this.copyProperties(rel, newRel);
            rel.delete();
            return Stream.of(result.withOther(newRel));
        }
        catch (Exception e) {
            return Stream.of(result.withError(e));
        }
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.refactor.from(rel, startNode) redirect relationship to use new start-node")
    public Stream<RelationshipRefactorResult> from(@Name(value="relationship") Relationship rel, @Name(value="newNode") Node newNode) {
        RelationshipRefactorResult result = new RelationshipRefactorResult(rel.getId());
        try {
            Relationship newRel = newNode.createRelationshipTo(rel.getEndNode(), rel.getType());
            this.copyProperties(rel, newRel);
            rel.delete();
            return Stream.of(result.withOther(newRel));
        }
        catch (Exception e) {
            return Stream.of(result.withError(e));
        }
    }

    private Node mergeNodes(Node source, Node target, boolean delete) {
        this.copyRelationships(source, this.copyProperties(source, this.copyLabels(source, target)), delete);
        if (delete) {
            source.delete();
        }
        return target;
    }

    private Node copyRelationships(Node source, Node target, boolean delete) {
        for (Relationship rel : source.getRelationships()) {
            this.copyRelationship(rel, source, target);
            if (!delete) continue;
            rel.delete();
        }
        return target;
    }

    private Node copyLabels(Node source, Node target) {
        for (Label label : source.getLabels()) {
            target.addLabel(label);
        }
        return target;
    }

    private <T extends PropertyContainer> T copyProperties(T source, T target) {
        for (Map.Entry prop : source.getAllProperties().entrySet()) {
            target.setProperty((String)prop.getKey(), prop.getValue());
        }
        return target;
    }

    private Relationship copyRelationship(Relationship rel, Node source, Node newSource) {
        return this.copyProperties(rel, newSource.createRelationshipTo(rel.getOtherNode(source), rel.getType()));
    }
}

