/*
 * Decompiled with CFR 0.152.
 */
package apoc.periodic;

import apoc.Description;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.neo4j.graphdb.Result;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.PerformsWrites;
import org.neo4j.procedure.Procedure;

public class Periodic {
    static final ScheduledExecutorService jobs = Executors.newScheduledThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() / 4));
    @Context
    public GraphDatabaseAPI db;
    static final Map<JobInfo, Future> list = new ConcurrentHashMap<JobInfo, Future>();
    @Context
    public KernelTransaction tx;

    @Procedure
    @Description(value="apoc.periodic.list - list all jobs")
    public Stream<JobInfo> list() {
        return list.entrySet().stream().map(e -> ((JobInfo)e.getKey()).update((Future)e.getValue()));
    }

    @Procedure
    @PerformsWrites
    @Description(value="apoc.periodic.commit(statement,params) - runs the given statement in separate transactions until it returns 0")
    public Stream<RundownResult> commit(@Name(value="statement") String statement, @Name(value="params") Map<String, Object> parameters) throws ExecutionException, InterruptedException {
        long count;
        Map<Object, Object> params = parameters == null ? Collections.emptyMap() : parameters;
        long sum = 0L;
        long executions = 0L;
        long start = System.currentTimeMillis();
        do {
            count = jobs.submit(() -> this.executeNumericResultStatement(statement, params)).get();
            sum += count;
            if (count <= 0L) continue;
            ++executions;
        } while (count > 0L);
        return Stream.of(new RundownResult(sum, executions, System.currentTimeMillis() - start));
    }

    private long executeNumericResultStatement(@Name(value="statement") String statement, @Name(value="params") Map<String, Object> parameters) {
        long sum = 0L;
        try (Result result = this.db.execute(statement, parameters);){
            while (result.hasNext()) {
                Collection row = result.next().values();
                for (Object value : row) {
                    if (!(value instanceof Number)) continue;
                    sum += ((Number)value).longValue();
                }
            }
        }
        return sum;
    }

    @Procedure
    @Description(value="apoc.periodic.cancel(name) - cancel job with the given name")
    public Stream<JobInfo> cancel(@Name(value="name") String name) {
        JobInfo info = new JobInfo(name);
        Future future = list.remove(info);
        if (future != null) {
            future.cancel(true);
            return Stream.of(info.update(future));
        }
        return Stream.empty();
    }

    @Procedure
    @Description(value="apoc.periodic.submit('name',statement) - submit a one-off background statement")
    public Stream<JobInfo> submit(@Name(value="name") String name, @Name(value="statement") String statement) {
        JobInfo info = Periodic.submit(name, () -> {
            try {
                Iterators.count((Iterator)this.db.execute(statement));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return Stream.of(info);
    }

    @Procedure
    @Description(value="apoc.periodic.schedule('name',statement,repeat-time-in-seconds) submit a repeatedly-called background statement")
    public Stream<JobInfo> repeat(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="rate") long rate) {
        JobInfo info = Periodic.schedule(name, () -> Iterators.count((Iterator)this.db.execute(statement)), 0L, rate);
        return Stream.of(info);
    }

    @Description(value="apoc.periodic.countdown('name',statement,repeat-time-in-seconds) submit a repeatedly-called background statement until it returns 0")
    public Stream<JobInfo> countdown(@Name(value="name") String name, @Name(value="statement") String statement, @Name(value="rate") long rate) {
        JobInfo info = Periodic.submit(name, new Countdown(name, statement, rate));
        return Stream.of(info);
    }

    public static <T> JobInfo submit(String name, Runnable task) {
        JobInfo info = new JobInfo(name);
        Future future = list.remove(info);
        if (future != null && !future.isDone()) {
            future.cancel(false);
        }
        Future<?> newFuture = jobs.submit(task);
        list.put(info, newFuture);
        return info;
    }

    public static JobInfo schedule(String name, Runnable task, long delay, long repeat) {
        JobInfo info = new JobInfo(name, delay, repeat);
        Future future = list.remove(info);
        if (future != null && !future.isDone()) {
            future.cancel(false);
        }
        ScheduledFuture<?> newFuture = jobs.scheduleWithFixedDelay(task, delay, repeat, TimeUnit.SECONDS);
        list.put(info, newFuture);
        return info;
    }

    public static JobInfo schedule(String name, Runnable task, long delay) {
        JobInfo info = new JobInfo(name, delay, 0L);
        Future future = list.remove(info);
        if (future != null) {
            future.cancel(false);
        }
        ScheduledFuture<?> newFuture = jobs.schedule(task, delay, TimeUnit.SECONDS);
        list.put(info, newFuture);
        return info;
    }

    static {
        Runnable runnable = () -> {
            Iterator<Map.Entry<JobInfo, Future>> it = list.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<JobInfo, Future> entry = it.next();
                if (!entry.getValue().isDone() && !entry.getValue().isCancelled()) continue;
                it.remove();
            }
        };
        jobs.scheduleAtFixedRate(runnable, 10L, 10L, TimeUnit.SECONDS);
    }

    private class Countdown
    implements Runnable {
        private final String name;
        private final String statement;
        private final long rate;

        public Countdown(String name, String statement, long rate) {
            this.name = name;
            this.statement = statement;
            this.rate = rate;
        }

        @Override
        public void run() {
            if (Periodic.this.executeNumericResultStatement(this.statement, null) > 0L) {
                jobs.schedule(() -> Periodic.submit(this.name, this), this.rate, TimeUnit.SECONDS);
            }
        }
    }

    public static class JobInfo {
        public final String name;
        public long delay;
        public long rate;
        public boolean done;
        public boolean cancelled;

        public JobInfo(String name) {
            this.name = name;
        }

        public JobInfo(String name, long delay, long rate) {
            this.name = name;
            this.delay = delay;
            this.rate = rate;
        }

        public JobInfo update(Future future) {
            this.done = future.isDone();
            this.cancelled = future.isCancelled();
            return this;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof JobInfo && this.name.equals(((JobInfo)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    public static class RundownResult {
        public final long updates;
        public final long executions;
        public final long runtime;

        public RundownResult(long updates, long executions, long runtime) {
            this.updates = updates;
            this.executions = executions;
            this.runtime = runtime;
        }
    }
}

