/*
 * Decompiled with CFR 0.152.
 */
package apoc.path;

import apoc.Description;
import apoc.result.PathResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpanderBuilder;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.Uniqueness;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.logging.Log;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class PathExplorer {
    private static final String VERSION = "0.5";
    public static final Uniqueness UNIQUENESS = Uniqueness.RELATIONSHIP_PATH;
    @Context
    public GraphDatabaseService db;
    @Context
    public Log log;

    public Stream<InfoContainer> info() {
        return this.getInfo().stream().map(InfoContainer::new);
    }

    @Procedure(value="apoc.path.expand")
    @Description(value="apoc.path.expand(startNode <id>|Node|list, 'TYPE|TYPE_OUT>|<TYPE_IN', '+YesLabel|-NoLabel', minLevel, maxLevel ) yield path expand from start node following the given relationships from min to max-level adhering to the label filters")
    public Stream<PathResult> explorePath(@Name(value="start") Object start, @Name(value="relationshipFilter") String pathFilter, @Name(value="labelFilter") String labelFilter, @Name(value="minLevel") long minLevel, @Name(value="maxLevel") long maxLevel) throws Exception {
        List<Node> nodes = this.startToNodes(start);
        return this.explorePathPrivate(nodes, pathFilter, labelFilter, minLevel, maxLevel);
    }

    private List<Node> startToNodes(Object start) throws Exception {
        if (start == null) {
            return Collections.emptyList();
        }
        if (start instanceof Node) {
            return Collections.singletonList((Node)start);
        }
        if (start instanceof Number) {
            return Collections.singletonList(this.db.getNodeById(((Number)start).longValue()));
        }
        if (start instanceof List) {
            List list = (List)start;
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            Object first = list.get(0);
            if (first instanceof Node) {
                return list;
            }
            if (first instanceof Number) {
                ArrayList<Node> nodes = new ArrayList<Node>();
                for (Number n : list) {
                    nodes.add(this.db.getNodeById(n.longValue()));
                }
                return nodes;
            }
        }
        throw new Exception("Unsupported data type for start parameter a Node or an Identifier (long) of a Node must be given!");
    }

    private Direction directionFor(String type) {
        if (type.contains("<")) {
            return Direction.INCOMING;
        }
        if (type.contains(">")) {
            return Direction.OUTGOING;
        }
        return Direction.BOTH;
    }

    private Stream<PathResult> explorePathPrivate(Iterable<Node> startNodes, String pathFilter, String labelFilter, long minLevel, long maxLevel) {
        String[] defs;
        int from = new Long(minLevel).intValue();
        int to = new Long(maxLevel).intValue();
        TraversalDescription td = this.db.traversalDescription().breadthFirst();
        if (pathFilter != null && !(defs = pathFilter.split("\\|"))[0].isEmpty()) {
            for (String def : defs) {
                Direction direction = this.directionFor(def);
                DynRelationshipType relType = new DynRelationshipType(def);
                td = relType.name().isEmpty() ? td.expand(PathExpanderBuilder.allTypes((Direction)direction).build()) : td.relationships((RelationshipType)relType, direction);
            }
        }
        LabelEvaluator labelEvaluator = new LabelEvaluator(labelFilter);
        td = td.evaluator(Evaluators.fromDepth((int)from)).evaluator(Evaluators.toDepth((int)to)).evaluator((Evaluator)labelEvaluator);
        td = td.uniqueness((UniquenessFactory)UNIQUENESS);
        return td.traverse(startNodes).stream().map(PathResult::new);
    }

    private List<String> getInfo() {
        LinkedList<String> infolist = new LinkedList<String>();
        infolist.add("explorePath version 0.5");
        infolist.add("usage call explorePath(startNode <id>|Node, relationshipFilter, labelFilter, minLevel, maxLevel )");
        infolist.add("- startnode <id> (long, int) or Node");
        infolist.add("> > relationshipFilter RELATIONSHIP_TYPE1{<,>,}|RELATIONSHIP_TYPE2{<,>,}|... ");
        infolist.add("> > RELATIONSHIP_TYPE> = only direction Outgoing");
        infolist.add("> > RELATIONSHIP_TYPE< = only direction Incoming");
        infolist.add("> > RELATIONSHIP_TYPE = both directions");
        infolist.add("- labelFilter {+,-} LABEL1|LABEL2|...");
        infolist.add("> > '+' include label list (white list");
        infolist.add("> > '-' exclude label list (black list");
        infolist.add("- minLevel minimum path level");
        infolist.add("- maxLevel maximum path level");
        infolist.add(": RETURNS a variable with then name 'exploredPath' ");
        return infolist;
    }

    public static class LabelEvaluator
    implements Evaluator {
        private boolean included = true;
        private Set<String> labels = new HashSet<String>();

        public LabelEvaluator(String labelFilter) {
            String[] defs;
            if (labelFilter == null || labelFilter.equalsIgnoreCase("")) {
                labelFilter = "-";
            }
            this.included = labelFilter.startsWith("+");
            String work = labelFilter.substring(1);
            for (String def : defs = work.split("\\|")) {
                if (def.startsWith(":")) {
                    def = def.substring(1);
                }
                this.labels.add(def);
            }
        }

        public Evaluation evaluate(Path path) {
            Node check = path.endNode();
            if (this.included) {
                if (this.labelExists(check)) {
                    return Evaluation.INCLUDE_AND_CONTINUE;
                }
                return Evaluation.EXCLUDE_AND_PRUNE;
            }
            if (this.labelExists(check)) {
                return Evaluation.EXCLUDE_AND_PRUNE;
            }
            return Evaluation.INCLUDE_AND_CONTINUE;
        }

        private boolean labelExists(Node node) {
            for (Label lab : node.getLabels()) {
                if (!this.labels.contains(lab.name())) continue;
                return true;
            }
            return false;
        }
    }

    public static class InfoContainer {
        public String info;

        public InfoContainer(String inf) {
            this.info = inf;
        }
    }

    public class DynRelationshipType
    implements RelationshipType {
        private String name;

        public DynRelationshipType(String sname) {
            if (sname.startsWith(":")) {
                sname = sname.substring(1);
            }
            if (sname.endsWith(">") || sname.endsWith("<")) {
                sname = sname.substring(0, sname.length() - 1);
            }
            this.name = sname;
        }

        public String name() {
            return this.name;
        }
    }
}

