/*
 * Decompiled with CFR 0.152.
 */
package apoc.monitor;

import apoc.Description;
import apoc.result.IdsResult;
import java.util.stream.Stream;
import javax.management.ObjectName;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.jmx.JmxUtils;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Procedure;

public class Ids {
    private static final String JMX_OBJECT_NAME = "Primitive count";
    private static final String NODE_IDS_KEY = "NumberOfNodeIdsInUse";
    private static final String REL_IDS_KEY = "NumberOfRelationshipIdsInUse";
    private static final String PROP_IDS_KEY = "NumberOfPropertyIdsInUse";
    private static final String REL_TYPE_IDS_KEY = "NumberOfRelationshipTypeIdsInUse";
    @Context
    public GraphDatabaseService db;

    @Procedure
    @Description(value="apoc.monitor.ids() returns the object ids in use for this neo4j instance")
    public Stream<IdsResult> ids() {
        return Stream.of(this.getIdsInUse());
    }

    private IdsResult getIdsInUse() {
        ObjectName objectName = JmxUtils.getObjectName((GraphDatabaseService)this.db, (String)JMX_OBJECT_NAME);
        return new IdsResult((Long)JmxUtils.getAttribute((ObjectName)objectName, (String)NODE_IDS_KEY), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)REL_IDS_KEY), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)PROP_IDS_KEY), (Long)JmxUtils.getAttribute((ObjectName)objectName, (String)REL_TYPE_IDS_KEY));
    }
}

